/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.ballerinalang.net.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.config.ListenerConfiguration;
import org.wso2.transport.http.netty.contract.config.Parameter;
import org.wso2.transport.http.netty.contract.config.SenderConfiguration;
import org.wso2.transport.http.netty.contract.config.SslConfiguration;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.ConnectionManager;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.PoolConfiguration;

public class GrpcUtil {
    private static final Logger log = LoggerFactory.getLogger(GrpcUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionManager getConnectionManager(MapValue<String, Long> poolStruct) {
        ConnectionManager poolManager = (ConnectionManager)poolStruct.getNativeData("ConnectionManager");
        if (poolManager == null) {
            MapValue<String, Long> mapValue = poolStruct;
            synchronized (mapValue) {
                if (poolStruct.getNativeData("ConnectionManager") == null) {
                    PoolConfiguration userDefinedPool = new PoolConfiguration();
                    GrpcUtil.populatePoolingConfig(poolStruct, userDefinedPool);
                    poolManager = new ConnectionManager(userDefinedPool);
                    poolStruct.addNativeData("ConnectionManager", (Object)poolManager);
                }
            }
        }
        return poolManager;
    }

    public static void populatePoolingConfig(MapValue<String, Long> poolRecord, PoolConfiguration poolConfiguration) {
        long maxActiveConnections = (Long)poolRecord.get((Object)"maxActiveConnections");
        poolConfiguration.setMaxActivePerPool(GrpcUtil.validateConfig(maxActiveConnections, "maxActiveConnections"));
        long maxIdleConnections = (Long)poolRecord.get((Object)"maxIdleConnections");
        poolConfiguration.setMaxIdlePerPool(GrpcUtil.validateConfig(maxIdleConnections, "maxIdleConnections"));
        long waitTime = (Long)poolRecord.get((Object)"waitTimeInMillis");
        poolConfiguration.setMaxWaitTime(waitTime);
        long maxActiveStreamsPerConnection = (Long)poolRecord.get((Object)"maxActiveStreamsPerConnection");
        poolConfiguration.setHttp2MaxActiveStreamsPerConnection(maxActiveStreamsPerConnection == -1L ? Integer.MAX_VALUE : GrpcUtil.validateConfig(maxActiveStreamsPerConnection, "maxActiveStreamsPerConnection"));
    }

    public static void populateSenderConfigurations(SenderConfiguration senderConfiguration, MapValue<String, Object> clientEndpointConfig, String scheme) {
        MapValue secureSocket = clientEndpointConfig.getMapValue("secureSocket");
        if (secureSocket != null) {
            GrpcUtil.populateSSLConfiguration((SslConfiguration)senderConfiguration, secureSocket);
        } else if (scheme.equals("https")) {
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("To enable https you need to configure secureSocket record")));
        }
        long timeoutMillis = clientEndpointConfig.getIntValue("timeoutInMillis");
        if (timeoutMillis < 0L) {
            senderConfiguration.setSocketIdleTimeout(0);
        } else {
            senderConfiguration.setSocketIdleTimeout(GrpcUtil.validateConfig(timeoutMillis, "timeoutInMillis"));
        }
    }

    public static void populateSSLConfiguration(SslConfiguration sslConfiguration, MapValue secureSocket) {
        List<String> ciphersValueList;
        MapValue trustStore = secureSocket.getMapValue("trustStore");
        MapValue keyStore = secureSocket.getMapValue("keyStore");
        MapValue protocols = secureSocket.getMapValue("protocol");
        MapValue validateCert = secureSocket.getMapValue("certValidation");
        String keyFile = secureSocket.getStringValue("keyFile");
        String certFile = secureSocket.getStringValue("certFile");
        String trustCerts = secureSocket.getStringValue("trustedCertFile");
        String keyPassword = secureSocket.getStringValue("keyPassword");
        boolean disableSslValidation = secureSocket.getBooleanValue("disable");
        ArrayList<Parameter> clientParams = new ArrayList<Parameter>();
        if (disableSslValidation) {
            sslConfiguration.disableSsl();
            return;
        }
        if (trustStore != null && StringUtils.isNotBlank((CharSequence)trustCerts)) {
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Cannot configure both trustStore and trustCerts at the same time.")));
        }
        if (trustStore != null) {
            String trustStorePassword;
            String trustStoreFile = trustStore.getStringValue("path");
            if (StringUtils.isNotBlank((CharSequence)trustStoreFile)) {
                sslConfiguration.setTrustStoreFile(trustStoreFile);
            }
            if (StringUtils.isNotBlank((CharSequence)(trustStorePassword = trustStore.getStringValue("password")))) {
                sslConfiguration.setTrustStorePass(trustStorePassword);
            }
        } else if (StringUtils.isNotBlank((CharSequence)trustCerts)) {
            sslConfiguration.setClientTrustCertificates(trustCerts);
        }
        if (keyStore != null && StringUtils.isNotBlank((CharSequence)keyFile)) {
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Cannot configure both keyStore and keyFile.")));
        }
        if (StringUtils.isNotBlank((CharSequence)keyFile) && StringUtils.isBlank((CharSequence)certFile)) {
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Need to configure certFile containing client ssl certificates.")));
        }
        if (keyStore != null) {
            String keyStorePassword;
            String keyStoreFile = keyStore.getStringValue("path");
            if (StringUtils.isNotBlank((CharSequence)keyStoreFile)) {
                sslConfiguration.setKeyStoreFile(keyStoreFile);
            }
            if (StringUtils.isNotBlank((CharSequence)(keyStorePassword = keyStore.getStringValue("password")))) {
                sslConfiguration.setKeyStorePass(keyStorePassword);
            }
        } else if (StringUtils.isNotBlank((CharSequence)keyFile)) {
            sslConfiguration.setClientKeyFile(keyFile);
            sslConfiguration.setClientCertificates(certFile);
            if (StringUtils.isNotBlank((CharSequence)keyPassword)) {
                sslConfiguration.setClientKeyPassword(keyPassword);
            }
        }
        if (protocols != null) {
            String sslProtocol;
            List<String> sslEnabledProtocolsValueList = Arrays.asList(protocols.getArrayValue("versions").getStringArray());
            if (!sslEnabledProtocolsValueList.isEmpty()) {
                String sslEnabledProtocols = sslEnabledProtocolsValueList.stream().collect(Collectors.joining(",", "", ""));
                Parameter clientProtocols = new Parameter("sslEnabledProtocols", sslEnabledProtocols);
                clientParams.add(clientProtocols);
            }
            if (StringUtils.isNotBlank((CharSequence)(sslProtocol = protocols.getStringValue("name")))) {
                sslConfiguration.setSSLProtocol(sslProtocol);
            }
        }
        if (validateCert != null) {
            boolean validateCertEnabled = validateCert.getBooleanValue("enable");
            int cacheSize = validateCert.getIntValue("cacheSize").intValue();
            int cacheValidityPeriod = validateCert.getIntValue("cacheValidityPeriod").intValue();
            sslConfiguration.setValidateCertEnabled(validateCertEnabled);
            if (cacheValidityPeriod != 0) {
                sslConfiguration.setCacheValidityPeriod(cacheValidityPeriod);
            }
            if (cacheSize != 0) {
                sslConfiguration.setCacheSize(cacheSize);
            }
        }
        boolean hostNameVerificationEnabled = secureSocket.getBooleanValue("verifyHostname");
        boolean ocspStaplingEnabled = secureSocket.getBooleanValue("ocspStapling");
        sslConfiguration.setOcspStaplingEnabled(ocspStaplingEnabled);
        sslConfiguration.setHostNameVerificationEnabled(hostNameVerificationEnabled);
        sslConfiguration.setSslSessionTimeOut((int)secureSocket.getDefaultableIntValue("sessionTimeoutInSeconds"));
        sslConfiguration.setSslHandshakeTimeOut(secureSocket.getDefaultableIntValue("handshakeTimeoutInSeconds"));
        String[] cipherConfigs = secureSocket.getArrayValue("ciphers").getStringArray();
        if (cipherConfigs != null && (ciphersValueList = Arrays.asList(cipherConfigs)).size() > 0) {
            String ciphers = ciphersValueList.stream().map(Object::toString).collect(Collectors.joining(",", "", ""));
            Parameter clientCiphers = new Parameter("ciphers", ciphers);
            clientParams.add(clientCiphers);
        }
        String enableSessionCreation = String.valueOf(secureSocket.getBooleanValue("shareSession"));
        Parameter clientEnableSessionCreation = new Parameter("shareSession", enableSessionCreation);
        clientParams.add(clientEnableSessionCreation);
        if (!clientParams.isEmpty()) {
            sslConfiguration.setParameters(clientParams);
        }
    }

    public static ListenerConfiguration getListenerConfig(long port, MapValue endpointConfig) {
        String host = endpointConfig.getStringValue("host");
        MapValue sslConfig = endpointConfig.getMapValue("secureSocket");
        long idleTimeout = endpointConfig.getIntValue("timeoutInMillis");
        ListenerConfiguration listenerConfiguration = new ListenerConfiguration();
        if (host == null || host.trim().isEmpty()) {
            listenerConfiguration.setHost(ConfigRegistry.getInstance().getConfigOrDefault("b7a.http.host", "0.0.0.0"));
        } else {
            listenerConfiguration.setHost(host);
        }
        if (port == 0L) {
            throw new BallerinaConnectorException("Listener port is not defined!");
        }
        listenerConfiguration.setPort(Math.toIntExact(port));
        if (idleTimeout < 0L) {
            throw new BallerinaConnectorException("Idle timeout cannot be negative. If you want to disable the timeout please use value 0");
        }
        listenerConfiguration.setSocketIdleTimeout(Math.toIntExact(idleTimeout));
        listenerConfiguration.setVersion("2.0");
        if (endpointConfig.getType().getName().equalsIgnoreCase("ListenerConfiguration")) {
            String serverName = endpointConfig.getStringValue("server");
            listenerConfiguration.setServerHeader(serverName != null ? serverName : GrpcUtil.getServerName());
        } else {
            listenerConfiguration.setServerHeader(GrpcUtil.getServerName());
        }
        if (sslConfig != null) {
            return GrpcUtil.setSslConfig(sslConfig, listenerConfiguration);
        }
        listenerConfiguration.setPipeliningEnabled(true);
        return listenerConfiguration;
    }

    private static String getServerName() {
        String version = System.getProperty("ballerina.version");
        String userAgent = version != null ? "ballerina/" + version : "ballerina";
        return userAgent;
    }

    private static ListenerConfiguration setSslConfig(MapValue sslConfig, ListenerConfiguration listenerConfiguration) {
        long cacheValidationPeriod;
        long cacheSize;
        List<String> ciphersValueList;
        Parameter serverParameters;
        listenerConfiguration.setScheme("https");
        MapValue trustStore = sslConfig.getMapValue("trustStore");
        MapValue keyStore = sslConfig.getMapValue("keyStore");
        MapValue protocols = sslConfig.getMapValue("protocol");
        MapValue validateCert = sslConfig.getMapValue("certValidation");
        MapValue ocspStapling = sslConfig.getMapValue("ocspStapling");
        String keyFile = sslConfig.getStringValue("keyFile");
        String certFile = sslConfig.getStringValue("certFile");
        String trustCerts = sslConfig.getStringValue("trustedCertFile");
        String keyPassword = sslConfig.getStringValue("keyPassword");
        if (keyStore != null && StringUtils.isNotBlank((CharSequence)keyFile)) {
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Cannot configure both keyStore and keyFile at the same time.")));
        }
        if (keyStore == null && (StringUtils.isBlank((CharSequence)keyFile) || StringUtils.isBlank((CharSequence)certFile))) {
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Either keystore or certificateKey and server certificates must be provided for secure connection")));
        }
        if (keyStore != null) {
            String keyStoreFile = keyStore.getStringValue("path");
            if (StringUtils.isBlank((CharSequence)keyStoreFile)) {
                throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Keystore file location must be provided for secure connection.")));
            }
            String keyStorePassword = keyStore.getStringValue("password");
            if (StringUtils.isBlank((CharSequence)keyStorePassword)) {
                throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Keystore password must be provided for secure connection")));
            }
            listenerConfiguration.setKeyStoreFile(keyStoreFile);
            listenerConfiguration.setKeyStorePass(keyStorePassword);
        } else {
            listenerConfiguration.setServerKeyFile(keyFile);
            listenerConfiguration.setServerCertificates(certFile);
            if (StringUtils.isNotBlank((CharSequence)keyPassword)) {
                listenerConfiguration.setServerKeyPassword(keyPassword);
            }
        }
        String sslVerifyClient = sslConfig.getStringValue("sslVerifyClient");
        listenerConfiguration.setVerifyClient(sslVerifyClient);
        listenerConfiguration.setSslSessionTimeOut((int)sslConfig.getDefaultableIntValue("sessionTimeoutInSeconds"));
        listenerConfiguration.setSslHandshakeTimeOut(sslConfig.getDefaultableIntValue("handshakeTimeoutInSeconds"));
        if (trustStore == null && StringUtils.isNotBlank((CharSequence)sslVerifyClient) && StringUtils.isBlank((CharSequence)trustCerts)) {
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Truststore location or trustCertificates must be provided to enable Mutual SSL")));
        }
        if (trustStore != null) {
            String trustStoreFile = trustStore.getStringValue("path");
            String trustStorePassword = trustStore.getStringValue("password");
            if (StringUtils.isBlank((CharSequence)trustStoreFile) && StringUtils.isNotBlank((CharSequence)sslVerifyClient)) {
                throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Truststore location must be provided to enable Mutual SSL")));
            }
            if (StringUtils.isBlank((CharSequence)trustStorePassword) && StringUtils.isNotBlank((CharSequence)sslVerifyClient)) {
                throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Truststore password value must be provided to enable Mutual SSL")));
            }
            listenerConfiguration.setTrustStoreFile(trustStoreFile);
            listenerConfiguration.setTrustStorePass(trustStorePassword);
        } else if (StringUtils.isNotBlank((CharSequence)trustCerts)) {
            listenerConfiguration.setServerTrustCertificates(trustCerts);
        }
        ArrayList<Parameter> serverParamList = new ArrayList<Parameter>();
        if (protocols != null) {
            String sslProtocol;
            List<String> sslEnabledProtocolsValueList = Arrays.asList(protocols.getArrayValue("versions").getStringArray());
            if (!sslEnabledProtocolsValueList.isEmpty()) {
                String sslEnabledProtocols = sslEnabledProtocolsValueList.stream().collect(Collectors.joining(",", "", ""));
                serverParameters = new Parameter("sslEnabledProtocols", sslEnabledProtocols);
                serverParamList.add(serverParameters);
            }
            if (StringUtils.isNotBlank((CharSequence)(sslProtocol = protocols.getStringValue("name")))) {
                listenerConfiguration.setSSLProtocol(sslProtocol);
            }
        }
        if (!(ciphersValueList = Arrays.asList(sslConfig.getArrayValue("ciphers").getStringArray())).isEmpty()) {
            String ciphers = ciphersValueList.stream().collect(Collectors.joining(",", "", ""));
            serverParameters = new Parameter("ciphers", ciphers);
            serverParamList.add(serverParameters);
        }
        if (validateCert != null) {
            boolean validateCertificateEnabled = validateCert.getBooleanValue("enable");
            cacheSize = validateCert.getIntValue("cacheSize");
            cacheValidationPeriod = validateCert.getIntValue("cacheValidityPeriod");
            listenerConfiguration.setValidateCertEnabled(validateCertificateEnabled);
            if (validateCertificateEnabled) {
                if (cacheSize != 0L) {
                    listenerConfiguration.setCacheSize(Math.toIntExact(cacheSize));
                }
                if (cacheValidationPeriod != 0L) {
                    listenerConfiguration.setCacheValidityPeriod(Math.toIntExact(cacheValidationPeriod));
                }
            }
        }
        if (ocspStapling != null) {
            boolean ocspStaplingEnabled = ocspStapling.getBooleanValue("enable");
            listenerConfiguration.setOcspStaplingEnabled(ocspStaplingEnabled);
            cacheSize = ocspStapling.getIntValue("cacheSize");
            cacheValidationPeriod = ocspStapling.getIntValue("cacheValidityPeriod");
            listenerConfiguration.setValidateCertEnabled(ocspStaplingEnabled);
            if (ocspStaplingEnabled) {
                if (cacheSize != 0L) {
                    listenerConfiguration.setCacheSize(Math.toIntExact(cacheSize));
                }
                if (cacheValidationPeriod != 0L) {
                    listenerConfiguration.setCacheValidityPeriod(Math.toIntExact(cacheValidationPeriod));
                }
            }
        }
        listenerConfiguration.setTLSStoreType("PKCS12");
        String serverEnableSessionCreation = String.valueOf(sslConfig.getBooleanValue("shareSession"));
        Parameter enableSessionCreationParam = new Parameter("shareSession", serverEnableSessionCreation);
        serverParamList.add(enableSessionCreationParam);
        if (!serverParamList.isEmpty()) {
            listenerConfiguration.setParameters(serverParamList);
        }
        listenerConfiguration.setId(HttpUtil.getListenerInterface((String)listenerConfiguration.getHost(), (int)listenerConfiguration.getPort()));
        return listenerConfiguration;
    }

    private static int validateConfig(long value, String configName) {
        try {
            return Math.toIntExact(value);
        }
        catch (ArithmeticException e) {
            log.warn("The value set for the configuration needs to be less than {}. The " + configName + "value is set to {}", (Object)Integer.MAX_VALUE);
            return Integer.MAX_VALUE;
        }
    }
}

