/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ballerinalang.test.runtime.entity.CoverageReport;
import org.ballerinalang.test.runtime.entity.ModuleCoverage;

public class CoverageMain {
    public static void main(String[] args) throws Exception {
        Path targetDir = Paths.get(args[1], new String[0]);
        Path testJarPath = Paths.get(args[2], new String[0]);
        String orgName = args[3];
        String moduleName = args[4];
        CoverageReport coverageReport = new CoverageReport(testJarPath, targetDir, orgName, moduleName);
        coverageReport.generateReport();
        Path jsonTmpSummaryPath = Paths.get(args[0], "module_coverage.json");
        CoverageMain.writeCoverageToJsonFile(ModuleCoverage.getInstance(), jsonTmpSummaryPath);
    }

    private static void writeCoverageToJsonFile(ModuleCoverage moduleCoverage, Path tmpJsonPath) throws IOException {
        File jsonFile = new File(tmpJsonPath.toString());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), StandardCharsets.UTF_8);){
            Gson gson = new Gson();
            String json = gson.toJson(moduleCoverage);
            writer.write(new String(json.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
        }
    }
}

