/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.entity;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.test.runtime.entity.ModuleCoverage;
import org.ballerinalang.test.runtime.entity.ModuleStatus;

public class TestReport {
    private String projectName;
    private String orgName;
    private int totalTests;
    private int passed;
    private int failed;
    private int skipped;
    private int coveredLines;
    private int missedLines;
    private float coveragePercentage;
    private List<ModuleStatus> moduleStatus = new ArrayList<ModuleStatus>();
    private List<ModuleCoverage> moduleCoverage = new ArrayList<ModuleCoverage>();

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public List<ModuleStatus> getModuleStatus() {
        return this.moduleStatus;
    }

    public void setModuleStatus(List<ModuleStatus> moduleStatus) {
        this.moduleStatus = moduleStatus;
    }

    public void addModuleStatus(String moduleName, ModuleStatus status) {
        status.setName(moduleName);
        this.moduleStatus.add(status);
    }

    public List<ModuleCoverage> getModuleCoverage() {
        return this.moduleCoverage;
    }

    public void setModuleCoverage(List<ModuleCoverage> moduleCoverage) {
        this.moduleCoverage = moduleCoverage;
    }

    public void addCoverage(String moduleName, ModuleCoverage coverage) {
        coverage.setName(moduleName);
        this.moduleCoverage.add(coverage);
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void finalizeTestResults(boolean coverage) {
        for (ModuleStatus modStatus : this.moduleStatus) {
            if (".".equals(modStatus.getName())) {
                modStatus.setName(this.projectName);
            }
            this.passed += modStatus.getPassed();
            this.failed += modStatus.getFailed();
            this.skipped += modStatus.getSkipped();
            this.totalTests = this.passed + this.failed + this.skipped;
        }
        if (coverage) {
            for (ModuleCoverage modCov : this.moduleCoverage) {
                if (".".equals(modCov.getName())) {
                    modCov.setName(this.projectName);
                }
                this.coveredLines += modCov.getCoveredLines();
                this.missedLines += modCov.getMissedLines();
                float coverageVal = (float)this.coveredLines / (float)(this.coveredLines + this.missedLines) * 100.0f;
                this.coveragePercentage = (float)((double)Math.round((double)coverageVal * 100.0) / 100.0);
            }
        }
    }

    public float getCoveragePercentage() {
        return this.coveragePercentage;
    }

    public int getTotalTests() {
        return this.totalTests;
    }
}

