/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.test.runtime.entity.Test;

public class TestSuite {
    private String orgName;
    private String version;
    private String packageName;
    private String packageId;
    private String initFunctionName;
    private String startFunctionName;
    private String stopFunctionName;
    private String testInitFunctionName;
    private String testStartFunctionName;
    private String testStopFunctionName;
    private String sourceRootPath;
    private String sourceFileName;
    private Map<String, String> testUtilityFunctions = new HashMap<String, String>();
    private List<String> beforeSuiteFunctionNames = new ArrayList<String>();
    private List<String> afterSuiteFunctionNames = new ArrayList<String>();
    private List<String> beforeEachFunctionNames = new ArrayList<String>();
    private List<String> afterEachFunctionNames = new ArrayList<String>();
    private List<Test> tests = new ArrayList<Test>();
    private boolean isReportRequired;
    private Map<String, String> mockFunctionNamesMap = new HashMap<String, String>();

    public TestSuite(String packageId, String packageName, String orgName, String version) {
        this.packageId = packageId;
        this.packageName = packageName;
        this.orgName = orgName;
        this.version = version;
    }

    public String getPackageID() {
        return this.packageId;
    }

    public String getSourceRootPath() {
        return this.sourceRootPath;
    }

    public void setSourceRootPath(String sourceRootPath) {
        this.sourceRootPath = sourceRootPath;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getInitFunctionName() {
        return this.initFunctionName;
    }

    public void setInitFunctionName(String initFunctionName) {
        this.initFunctionName = initFunctionName;
    }

    public String getStartFunctionName() {
        return this.startFunctionName;
    }

    public void setStartFunctionName(String startFunctionName) {
        this.startFunctionName = startFunctionName;
    }

    public String getStopFunctionName() {
        return this.stopFunctionName;
    }

    public void setStopFunctionName(String stopFunctionName) {
        this.stopFunctionName = stopFunctionName;
    }

    public String getTestInitFunctionName() {
        return this.testInitFunctionName;
    }

    public void setTestInitFunctionName(String testInitFunctionName) {
        this.testInitFunctionName = testInitFunctionName;
    }

    public String getTestStartFunctionName() {
        return this.testStartFunctionName;
    }

    public void setTestStartFunctionName(String testStartFunctionName) {
        this.testStartFunctionName = testStartFunctionName;
    }

    public String getTestStopFunctionName() {
        return this.testStopFunctionName;
    }

    public void setTestStopFunctionName(String testStopFunctionName) {
        this.testStopFunctionName = testStopFunctionName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Map<String, String> getTestUtilityFunctions() {
        return this.testUtilityFunctions;
    }

    public List<String> getBeforeSuiteFunctionNames() {
        return this.beforeSuiteFunctionNames;
    }

    public List<String> getAfterSuiteFunctionNames() {
        return this.afterSuiteFunctionNames;
    }

    public List<String> getBeforeEachFunctionNames() {
        return this.beforeEachFunctionNames;
    }

    public List<String> getAfterEachFunctionNames() {
        return this.afterEachFunctionNames;
    }

    public List<Test> getTests() {
        return this.tests;
    }

    public void setTests(List<Test> tests) {
        this.tests = tests;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public void addBeforeSuiteFunction(String function) {
        this.beforeSuiteFunctionNames.add(function);
    }

    public void addAfterSuiteFunction(String function) {
        this.afterSuiteFunctionNames.add(function);
    }

    public void addBeforeEachFunction(String function) {
        this.beforeEachFunctionNames.add(function);
    }

    public void addAfterEachFunction(String function) {
        this.afterEachFunctionNames.add(function);
    }

    public void addMockFunction(String id, String function) {
        this.mockFunctionNamesMap.put(id, function);
    }

    public void addTestUtilityFunction(String functionName, String functionClassName) {
        this.testUtilityFunctions.put(functionName, functionClassName);
    }

    public void addTests(Test tests) {
        this.tests.add(tests);
    }

    public boolean isReportRequired() {
        return this.isReportRequired;
    }

    public void setReportRequired(boolean reportRequired) {
        this.isReportRequired = reportRequired;
    }
}

