/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core;

import com.codahale.metrics.MetricRegistry;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.metrics.core.MetricManagementService;
import org.wso2.carbon.metrics.core.MetricService;
import org.wso2.carbon.metrics.core.config.model.JmxConfig;
import org.wso2.carbon.metrics.core.config.model.MetricsConfig;
import org.wso2.carbon.metrics.core.config.model.MetricsLevelConfig;
import org.wso2.carbon.metrics.core.config.model.ReservoirConfig;
import org.wso2.carbon.metrics.core.impl.MetricManagementServiceImpl;
import org.wso2.carbon.metrics.core.impl.MetricManager;
import org.wso2.carbon.metrics.core.impl.MetricServiceImpl;
import org.wso2.carbon.metrics.core.impl.MetricsMXBeanImpl;
import org.wso2.carbon.metrics.core.jmx.MetricsMXBean;
import org.wso2.carbon.metrics.core.reporter.ReporterBuildException;
import org.wso2.carbon.metrics.core.spi.MetricsExtension;
import org.wso2.carbon.metrics.core.utils.Utils;

public class Metrics {
    private static final Logger logger = LoggerFactory.getLogger(Metrics.class);
    private final boolean enabled;
    private final boolean registerMBean;
    private final String mBeanName;
    private final MetricService metricService;
    private final MetricManagementService metricManagementService;
    private final List<MetricsExtension> metricsExtensions = new CopyOnWriteArrayList<MetricsExtension>();
    private final ConfigProvider configProvider;

    public Metrics(ConfigProvider configProvider) {
        MetricsConfig metricsConfig;
        this.configProvider = configProvider;
        MetricRegistry metricRegistry = new MetricRegistry();
        try {
            metricsConfig = (MetricsConfig)configProvider.getConfigurationObject(MetricsConfig.class);
        }
        catch (ConfigurationException e) {
            logger.error("Error loading Metrics Configuration", (Throwable)e);
            metricsConfig = new MetricsConfig();
        }
        MetricsLevelConfig metricsLevelConfig = metricsConfig.getLevels();
        ReservoirConfig reservoirConfig = metricsConfig.getReservoir();
        MetricManager metricManager = new MetricManager(metricRegistry, metricsLevelConfig, reservoirConfig);
        this.metricService = new MetricServiceImpl(metricManager);
        this.metricManagementService = new MetricManagementServiceImpl(metricManager);
        metricsConfig.getReporting().getReporterBuilders().forEach(reporterBuilder -> {
            try {
                this.metricManagementService.addReporter(reporterBuilder);
            }
            catch (ReporterBuildException e) {
                logger.warn("Reporter build failed", (Throwable)e);
            }
        });
        JmxConfig jmxConfig = metricsConfig.getJmx();
        this.enabled = metricsConfig.isEnabled();
        this.registerMBean = jmxConfig.isRegisterMBean();
        this.mBeanName = jmxConfig.getName();
        if (!Utils.isCarbonEnvironment()) {
            ServiceLoader.load(MetricsExtension.class).forEach(this::addMetricsExtension);
        }
    }

    private void registerMXBean(MetricsMXBean metricsMXBean) {
        block4: {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName name = new ObjectName(this.mBeanName);
                if (mBeanServer.isRegistered(name)) {
                    mBeanServer.unregisterMBean(name);
                }
                mBeanServer.registerMBean(metricsMXBean, name);
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("MetricManagerMXBean registered under name: %s", this.mBeanName));
                }
            }
            catch (JMException e) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error(String.format("MetricManagerMXBean registration failed. Name: %s", this.mBeanName), (Throwable)e);
            }
        }
    }

    private void unregisterMXBean() {
        block4: {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName name = new ObjectName(this.mBeanName);
                if (mBeanServer.isRegistered(name)) {
                    mBeanServer.unregisterMBean(name);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("MetricManagerMXBean with name '%s' was unregistered.", this.mBeanName));
                }
            }
            catch (JMException e) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error(String.format("MetricManagerMXBean with name '%s' was failed to unregister", this.mBeanName), (Throwable)e);
            }
        }
    }

    public void activate() {
        if (this.enabled) {
            this.metricManagementService.enable();
        }
        if (this.registerMBean) {
            MetricsMXBeanImpl metricsMXBean = new MetricsMXBeanImpl(this.metricManagementService);
            this.registerMXBean(metricsMXBean);
        }
        if (!Utils.isCarbonEnvironment()) {
            this.metricsExtensions.forEach(extension -> extension.activate(this.configProvider, this.metricService, this.metricManagementService));
        }
    }

    public void deactivate() {
        if (this.registerMBean) {
            this.unregisterMXBean();
        }
        this.metricManagementService.disable();
        if (!Utils.isCarbonEnvironment()) {
            this.metricsExtensions.forEach(extension -> extension.deactivate(this.metricService, this.metricManagementService));
        }
    }

    private void addMetricsExtension(MetricsExtension extension) {
        this.metricsExtensions.add(extension);
    }

    public MetricService getMetricService() {
        return this.metricService;
    }

    public MetricManagementService getMetricManagementService() {
        return this.metricManagementService;
    }
}

