/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authentication;

import io.ballerina.messaging.broker.auth.BrokerAuthConfiguration;
import io.ballerina.messaging.broker.auth.authentication.Authenticator;
import io.ballerina.messaging.broker.auth.authorization.UserStore;
import io.ballerina.messaging.broker.common.BrokerClassLoader;
import io.ballerina.messaging.broker.common.StartupContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticatorFactory.class);

    public Authenticator getAuthenticator(StartupContext startupContext, BrokerAuthConfiguration.AuthenticationConfiguration authenticationConfiguration, UserStore userStore) throws Exception {
        String authenticatorClass = authenticationConfiguration.getAuthenticator().getClassName();
        LOGGER.info("Initializing authenticator: {}", (Object)authenticatorClass);
        Authenticator authenticator = (Authenticator)BrokerClassLoader.loadClass((String)authenticatorClass, Authenticator.class);
        authenticator.initialize(startupContext, userStore, authenticationConfiguration.getAuthenticator().getProperties());
        return authenticator;
    }
}

