/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authentication.jaas;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class PlainSaslCallbackHandler
implements CallbackHandler {
    private String username;
    private char[] password;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
            this.clearCredentials();
        }
    }

    private void clearCredentials() {
        this.username = null;
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
            this.password = null;
        }
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setPassword(char ... password) {
        this.password = password;
    }
}

