/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authentication.jaas;

import com.sun.security.auth.UserPrincipal;
import io.ballerina.messaging.broker.auth.AuthException;
import io.ballerina.messaging.broker.auth.authentication.AuthResult;
import io.ballerina.messaging.broker.auth.authorization.UserStore;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class UserStoreLoginModule
implements LoginModule {
    private String userName;
    private String authenticationId;
    private char[] password;
    private boolean success = false;
    private UserPrincipal userPrincipal;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private UserStore userStore;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.userStore = (UserStore)options.get("broker.user.store.connector");
    }

    @Override
    public boolean login() throws AuthException {
        NameCallback userNameCallback = new NameCallback("userName");
        PasswordCallback passwordCallback = new PasswordCallback("password", false);
        Callback[] callbacks = new Callback[]{userNameCallback, passwordCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            throw new AuthException("Callback type does not support. ", e);
        }
        catch (IOException e) {
            throw new AuthException("Exception occurred while handling authentication data. ", e);
        }
        this.userName = userNameCallback.getName();
        this.password = passwordCallback.getPassword();
        AuthResult authResult = this.userStore.authenticate(this.userName, this.password);
        this.success = authResult.isAuthenticated();
        if (this.success) {
            this.authenticationId = authResult.getUserId();
        }
        return this.success;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.success) {
            this.userPrincipal = new UserPrincipal(this.authenticationId);
            if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
                this.subject.getPrincipals().add(this.userPrincipal);
            }
        }
        this.cleanAuthInputData();
        return this.success;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.success) {
            this.logout();
        } else {
            this.cleanAuthInputData();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.success = false;
        this.authenticationId = null;
        this.userPrincipal = null;
        this.cleanAuthInputData();
        return true;
    }

    private void cleanAuthInputData() {
        this.userName = null;
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
            this.password = null;
        }
    }
}

