/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authentication.sasl;

import io.ballerina.messaging.broker.auth.authentication.sasl.SaslServerBuilder;
import java.security.Provider;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerSecurityProvider
extends Provider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaslServerBuilder.class);
    private static final long serialVersionUID = -1576616958900657930L;

    public BrokerSecurityProvider(String name, Map<String, SaslServerBuilder> providerMap) {
        super(name, 1.0, "Provider for registry AMQP SASL server factories");
        this.register(providerMap);
    }

    private void register(Map<String, SaslServerBuilder> providerMap) {
        for (Map.Entry<String, SaslServerBuilder> saslServerBuilderEntry : providerMap.entrySet()) {
            if (saslServerBuilderEntry.getValue().getServerFactoryClass() != null) {
                this.put("SaslServerFactory." + saslServerBuilderEntry.getKey(), saslServerBuilderEntry.getValue().getServerFactoryClass().getName());
                continue;
            }
            LOGGER.warn("Broker cannot find server factory for auth mechanism : " + saslServerBuilderEntry.getKey());
        }
    }
}

