/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authorization;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.ballerina.messaging.broker.auth.BrokerAuthConfiguration;
import io.ballerina.messaging.broker.auth.authorization.Authorizer;
import io.ballerina.messaging.broker.auth.authorization.DiscretionaryAccessController;
import io.ballerina.messaging.broker.auth.authorization.MandatoryAccessController;
import io.ballerina.messaging.broker.auth.authorization.UserStore;
import io.ballerina.messaging.broker.auth.authorization.authorizer.empty.NoOpAuthorizer;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.DefaultAuthorizer;
import io.ballerina.messaging.broker.auth.authorization.provider.DefaultMacHandler;
import io.ballerina.messaging.broker.auth.authorization.provider.RdbmsDacHandler;
import io.ballerina.messaging.broker.common.BrokerClassLoader;
import io.ballerina.messaging.broker.common.StartupContext;
import io.ballerina.messaging.broker.common.config.BrokerCommonConfiguration;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizerFactory.class);

    public static Authorizer getAuthorizer(BrokerCommonConfiguration commonConfiguration, BrokerAuthConfiguration brokerAuthConfiguration, UserStore userStore, StartupContext startupContext) throws Exception {
        if (brokerAuthConfiguration.getAuthentication().isEnabled() && brokerAuthConfiguration.getAuthorization().isEnabled()) {
            DiscretionaryAccessController dacHandler = AuthorizerFactory.getDac(brokerAuthConfiguration, commonConfiguration, startupContext, userStore);
            MandatoryAccessController macHandler = AuthorizerFactory.getMandatoryAccessController(brokerAuthConfiguration, commonConfiguration, startupContext, userStore);
            DefaultAuthorizer authorizer = new DefaultAuthorizer(dacHandler, macHandler, userStore);
            authorizer.initialize(startupContext);
            return authorizer;
        }
        return new NoOpAuthorizer();
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Not an issue since a RuntimeException is thrown")
    private static MandatoryAccessController getMandatoryAccessController(BrokerAuthConfiguration brokerAuthConfiguration, BrokerCommonConfiguration commonConfiguration, StartupContext startupContext, UserStore userStore) {
        String macHandlerClassName = brokerAuthConfiguration.getAuthorization().getMandatoryAccessController().getClassName();
        if (commonConfiguration.getEnableInMemoryMode() && DefaultMacHandler.class.getCanonicalName().equals(macHandlerClassName)) {
            throw new RuntimeException("Cannot use " + macHandlerClassName + " with in-memory mode.");
        }
        LOGGER.info("Initializing Mandatory Access Controller {}", (Object)macHandlerClassName);
        try {
            MandatoryAccessController macHandler = (MandatoryAccessController)BrokerClassLoader.loadClass((String)macHandlerClassName, MandatoryAccessController.class);
            Map<String, String> macProperties = brokerAuthConfiguration.getAuthorization().getMandatoryAccessController().getProperties();
            macHandler.initialize(startupContext, userStore, macProperties);
            return macHandler;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize Mandatory Access Controller", e);
        }
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Not an issue since a RuntimeException is thrown")
    private static DiscretionaryAccessController getDac(BrokerAuthConfiguration brokerAuthConfiguration, BrokerCommonConfiguration commonConfiguration, StartupContext startupContext, UserStore userStore) {
        String dacHandlerClassName = brokerAuthConfiguration.getAuthorization().getDiscretionaryAccessController().getClassName();
        if (commonConfiguration.getEnableInMemoryMode() && RdbmsDacHandler.class.getCanonicalName().equals(dacHandlerClassName)) {
            throw new RuntimeException("Cannot use " + dacHandlerClassName + " with in-memory mode.");
        }
        LOGGER.info("Initializing Discretionary Access Controller {}", (Object)dacHandlerClassName);
        try {
            DiscretionaryAccessController dacHandler = (DiscretionaryAccessController)BrokerClassLoader.loadClass((String)dacHandlerClassName, DiscretionaryAccessController.class);
            Map<String, String> dacProperties = brokerAuthConfiguration.getAuthorization().getDiscretionaryAccessController().getProperties();
            dacHandler.initialize(startupContext, userStore, dacProperties);
            return dacHandler;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize Discretionary Access Controller", e);
        }
    }

    public static UserStore createUserStore(StartupContext startupContext, BrokerAuthConfiguration brokerAuthConfiguration) {
        String userStoreClassName = brokerAuthConfiguration.getAuthorization().getUserStore().getClassName();
        Map<String, String> properties = brokerAuthConfiguration.getAuthorization().getUserStore().getProperties();
        if (Objects.nonNull(userStoreClassName)) {
            try {
                UserStore userStore = (UserStore)BrokerClassLoader.loadClass((String)userStoreClassName, UserStore.class);
                userStore.initialize(startupContext, properties);
                return userStore;
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot initialize user store", e);
            }
        }
        throw new RuntimeException("Please configure a user store for ");
    }
}

