/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.dao.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.ballerina.messaging.broker.auth.AuthServerException;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.AuthResource;
import io.ballerina.messaging.broker.common.BaseDao;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;

class AuthResourceCrudOperationsDao
extends BaseDao {
    AuthResourceCrudOperationsDao(DataSource dataSource) {
        super(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistUserGroupMappings(Connection connection, String resourceType, String resource, Map<String, Set<String>> userGroupsMapping) throws SQLException {
        PreparedStatement insertMappingsStmt = null;
        try {
            insertMappingsStmt = connection.prepareStatement("INSERT INTO MB_AUTH_RESOURCE_MAPPING ( RESOURCE_ID, RESOURCE_ACTION, USER_GROUP_ID) SELECT RESOURCE_ID, ?, ? FROM MB_AUTH_RESOURCE WHERE RESOURCE_TYPE = ? AND RESOURCE_NAME = ?");
            for (Map.Entry<String, Set<String>> mapping : userGroupsMapping.entrySet()) {
                Set<String> userGroups = mapping.getValue();
                for (String userGroup : userGroups) {
                    insertMappingsStmt.setString(1, mapping.getKey());
                    insertMappingsStmt.setString(2, userGroup);
                    insertMappingsStmt.setString(3, resourceType);
                    insertMappingsStmt.setString(4, resource);
                    insertMappingsStmt.addBatch();
                }
            }
            insertMappingsStmt.executeBatch();
        }
        finally {
            this.close(insertMappingsStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteUserGroupMappings(Connection connection, String resourceType, String resource) throws SQLException {
        PreparedStatement deleteMappingsStmt = null;
        try {
            deleteMappingsStmt = connection.prepareStatement("DELETE FROM MB_AUTH_RESOURCE_MAPPING WHERE RESOURCE_ID IN ( SELECT RESOURCE_ID FROM MB_AUTH_RESOURCE WHERE RESOURCE_TYPE = ? AND RESOURCE_NAME = ? )");
            deleteMappingsStmt.setString(1, resourceType);
            deleteMappingsStmt.setString(2, resource);
            deleteMappingsStmt.execute();
        }
        finally {
            this.close(deleteMappingsStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateOwner(Connection connection, String resourceType, String resourceName, String newOwner) throws SQLException {
        PreparedStatement updateResourceOwnerStmt = null;
        try {
            updateResourceOwnerStmt = connection.prepareStatement("UPDATE MB_AUTH_RESOURCE SET OWNER_ID = ? WHERE RESOURCE_TYPE = ? AND RESOURCE_NAME= ?");
            updateResourceOwnerStmt.setString(1, newOwner);
            updateResourceOwnerStmt.setString(2, resourceType);
            updateResourceOwnerStmt.setString(3, resourceName);
            int updateRows = updateResourceOwnerStmt.executeUpdate();
            boolean bl = updateRows != 0;
            return bl;
        }
        finally {
            this.close(updateResourceOwnerStmt);
        }
    }

    public void storeResource(Connection connection, AuthResource authResource) throws AuthServerException {
        PreparedStatement insertAuthResourceStmt = null;
        try {
            insertAuthResourceStmt = connection.prepareStatement("INSERT INTO MB_AUTH_RESOURCE (RESOURCE_TYPE, RESOURCE_NAME, OWNER_ID) VALUES (?, ?, ?)");
            insertAuthResourceStmt.setString(1, authResource.getResourceType());
            insertAuthResourceStmt.setString(2, authResource.getResourceName());
            insertAuthResourceStmt.setString(3, authResource.getOwner());
            insertAuthResourceStmt.execute();
        }
        catch (SQLException e) {
            throw new AuthServerException("Error occurred while persisting resource.", e);
        }
        finally {
            this.close(insertAuthResourceStmt);
        }
    }

    public boolean deleteResource(Connection connection, String resourceType, String resource) throws AuthServerException {
        PreparedStatement deleteAuthResourceStmt = null;
        try {
            deleteAuthResourceStmt = connection.prepareStatement("DELETE FROM MB_AUTH_RESOURCE WHERE RESOURCE_TYPE = ? AND RESOURCE_NAME= ?");
            deleteAuthResourceStmt.setString(1, resourceType);
            deleteAuthResourceStmt.setString(2, resource);
            int affectedRows = deleteAuthResourceStmt.executeUpdate();
            boolean bl = affectedRows != 0;
            return bl;
        }
        catch (SQLException e) {
            throw new AuthServerException("Error occurred while deleting resource.", e);
        }
        finally {
            this.close(deleteAuthResourceStmt);
        }
    }

    public boolean addGroups(Connection connection, String resourceType, String resourceName, String action, List<String> groups) throws AuthServerException {
        PreparedStatement insertMappingsStmt = null;
        try {
            insertMappingsStmt = connection.prepareStatement("INSERT INTO MB_AUTH_RESOURCE_MAPPING ( RESOURCE_ID, RESOURCE_ACTION, USER_GROUP_ID) SELECT RESOURCE_ID, ?, ? FROM MB_AUTH_RESOURCE WHERE RESOURCE_TYPE = ? AND RESOURCE_NAME = ?");
            for (String group : groups) {
                insertMappingsStmt.setString(1, action);
                insertMappingsStmt.setString(2, group);
                insertMappingsStmt.setString(3, resourceType);
                insertMappingsStmt.setString(4, resourceName);
                insertMappingsStmt.addBatch();
            }
            int[] updateRows = insertMappingsStmt.executeBatch();
            boolean bl = updateRows.length > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new AuthServerException("Error occurred while persisting groups.", e);
        }
        finally {
            this.close(insertMappingsStmt);
        }
    }

    public boolean removeGroup(Connection connection, String resourceType, String resourceName, String action, String group) throws AuthServerException {
        PreparedStatement insertMappingsStmt = null;
        try {
            insertMappingsStmt = connection.prepareStatement("DELETE FROM MB_AUTH_RESOURCE_MAPPING WHERE RESOURCE_ID IN ( SELECT RESOURCE_ID FROM MB_AUTH_RESOURCE WHERE RESOURCE_TYPE = ? AND RESOURCE_NAME = ? ) AND RESOURCE_ACTION = ? AND USER_GROUP_ID = ?");
            insertMappingsStmt.setString(1, resourceType);
            insertMappingsStmt.setString(2, resourceName);
            insertMappingsStmt.setString(3, action);
            insertMappingsStmt.setString(4, group);
            int updateRows = insertMappingsStmt.executeUpdate();
            boolean bl = updateRows != 0;
            return bl;
        }
        catch (SQLException e) {
            throw new AuthServerException("Error occurred while persisting resource.", e);
        }
        finally {
            this.close(insertMappingsStmt);
        }
    }

    public AuthResource read(Connection connection, String resourceType, String resourceName) throws AuthServerException {
        Object action;
        ResultSet resultSet;
        PreparedStatement statement;
        block8: {
            HashMap<String, Set<String>> actionUserGroupMap = new HashMap<String, Set<String>>();
            String ownerId = null;
            statement = null;
            resultSet = null;
            statement = connection.prepareStatement("SELECT r.OWNER_ID, rm.RESOURCE_ACTION, rm.USER_GROUP_ID FROM MB_AUTH_RESOURCE_MAPPING rm RIGHT JOIN ( SELECT OWNER_ID,RESOURCE_ID FROM MB_AUTH_RESOURCE WHERE RESOURCE_TYPE = ? AND RESOURCE_NAME = ?) as r ON r.RESOURCE_ID = rm.RESOURCE_ID");
            statement.setString(1, resourceType);
            statement.setString(2, resourceName);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                if (Objects.isNull(ownerId)) {
                    ownerId = resultSet.getString(1);
                }
                if (!Objects.nonNull(action = resultSet.getString(2))) continue;
                HashSet<String> authorisedGroups = (HashSet<String>)actionUserGroupMap.get(action);
                if (Objects.isNull(authorisedGroups)) {
                    authorisedGroups = new HashSet<String>();
                    actionUserGroupMap.put((String)action, authorisedGroups);
                }
                authorisedGroups.add(resultSet.getString(3));
            }
            if (!Objects.nonNull(ownerId)) break block8;
            action = new AuthResource(resourceType, resourceName, true, ownerId, actionUserGroupMap);
            this.close(statement);
            this.close(resultSet);
            return action;
        }
        try {
            action = null;
        }
        catch (SQLException e) {
            try {
                throw new AuthServerException("Error occurred while retrieving auth resource for resource group : " + resourceType + " and resource : " + resourceName, e);
            }
            catch (Throwable throwable) {
                this.close(statement);
                this.close(resultSet);
                throw throwable;
            }
        }
        this.close(statement);
        this.close(resultSet);
        return action;
    }

    public List<AuthResource> readAll(Connection connection, String resourceType, String ownerId) throws AuthServerException {
        Object authResource;
        HashMap<String, Object> resourceMap = new HashMap<String, Object>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement("SELECT r.RESOURCE_NAME, rm.RESOURCE_ACTION, rm.USER_GROUP_ID FROM MB_AUTH_RESOURCE_MAPPING rm RIGHT JOIN ( SELECT RESOURCE_NAME, RESOURCE_ID  FROM MB_AUTH_RESOURCE WHERE RESOURCE_TYPE = ? AND OWNER_ID = ? ) r ON r.RESOURCE_ID = rm.RESOURCE_ID ");
            statement.setString(1, resourceType);
            statement.setString(2, ownerId);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String resourceName = resultSet.getString(1);
                String action = resultSet.getString(2);
                String userGroup = resultSet.getString(3);
                authResource = (AuthResource)resourceMap.get(resourceName);
                if (Objects.isNull(authResource)) {
                    authResource = new AuthResource(resourceType, resourceName, true, ownerId);
                    resourceMap.put(resourceName, authResource);
                }
                if (!Objects.nonNull(action)) continue;
                Set<String> userGroups = ((AuthResource)authResource).getActionsUserGroupsMap().get(action);
                if (Objects.isNull(userGroups)) {
                    userGroups = new HashSet<String>();
                    ((AuthResource)authResource).getActionsUserGroupsMap().put(action, userGroups);
                }
                userGroups.add(userGroup);
            }
            authResource = new ArrayList<AuthResource>(resourceMap.values());
        }
        catch (SQLException e) {
            try {
                throw new AuthServerException("Error occurred while retrieving auth data for resource group : " + resourceType, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(statement);
                throw throwable;
            }
        }
        this.close(resultSet);
        this.close(statement);
        return authResource;
    }

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    public List<AuthResource> readAll(Connection connection, String resourceType, String action, String ownerId, List<String> userGroups) throws AuthServerException {
        ArrayList<AuthResource> authResource2;
        HashMap<String, AuthResource> resourceMap = new HashMap<String, AuthResource>();
        String userGroupsList = this.getSQLFormattedIdList(userGroups.size());
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement("SELECT r.RESOURCE_NAME, rm.USER_GROUP_ID FROM MB_AUTH_RESOURCE_MAPPING rm RIGHT JOIN ( SELECT RESOURCE_NAME, RESOURCE_ID, OWNER_ID FROM MB_AUTH_RESOURCE WHERE RESOURCE_TYPE =  ?) as r ON r.RESOURCE_ID = rm.RESOURCE_ID WHERE r.OWNER_ID = ? OR ( rm.RESOURCE_ACTION = ? AND rm.USER_GROUP_ID IN (" + userGroupsList + "))");
            statement.setString(1, resourceType);
            statement.setString(2, ownerId);
            statement.setString(3, action);
            for (int i = 0; i < userGroups.size(); ++i) {
                statement.setString(i + 4, userGroups.get(i));
            }
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String resourceName = resultSet.getString(1);
                String userGroup = resultSet.getString(2);
                AuthResource authResource2 = (AuthResource)resourceMap.get(resourceName);
                if (Objects.isNull(authResource2)) {
                    authResource2 = new AuthResource(resourceType, resourceName, true, ownerId);
                    resourceMap.put(resourceName, authResource2);
                }
                if (!Objects.nonNull(userGroup)) continue;
                Set<String> authorizedUserGroups = authResource2.getActionsUserGroupsMap().get(action);
                if (Objects.isNull(authorizedUserGroups)) {
                    authorizedUserGroups = new HashSet<String>();
                    authResource2.getActionsUserGroupsMap().put(action, authorizedUserGroups);
                }
                authorizedUserGroups.add(userGroup);
            }
            authResource2 = new ArrayList<AuthResource>(resourceMap.values());
        }
        catch (SQLException e) {
            try {
                throw new AuthServerException("Error occurred while retrieving auth data for resource group : " + resourceType, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(statement);
                throw throwable;
            }
        }
        this.close(resultSet);
        this.close(statement);
        return authResource2;
    }

    public boolean isExists(Connection connection, String resourceType, String resource) throws AuthServerException {
        boolean bl;
        String resourceId = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement("SELECT RESOURCE_ID FROM MB_AUTH_RESOURCE WHERE RESOURCE_TYPE = ? AND RESOURCE_NAME = ?");
            statement.setString(1, resourceType);
            statement.setString(2, resource);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resourceId = resultSet.getString(1);
            }
            bl = Objects.nonNull(resourceId);
        }
        catch (SQLException e) {
            try {
                throw new AuthServerException("Error occurred while retrieving existence of resource for resource group : " + resourceType + " and resource : " + resource, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(statement);
                throw throwable;
            }
        }
        this.close(resultSet);
        this.close(statement);
        return bl;
    }
}

