/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.dao.impl;

import io.ballerina.messaging.broker.auth.AuthServerException;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.AuthResource;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.dao.AuthResourceDao;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.dao.impl.AuthResourceCrudOperationsDao;
import io.ballerina.messaging.broker.common.DaoException;
import io.ballerina.messaging.broker.common.util.function.ThrowingConsumer;
import io.ballerina.messaging.broker.common.util.function.ThrowingFunction;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;

public class AuthResourceRdbmsDao
implements AuthResourceDao {
    private final AuthResourceCrudOperationsDao authResourceCrudOperationsDao;

    public AuthResourceRdbmsDao(DataSource dataSource) {
        this.authResourceCrudOperationsDao = new AuthResourceCrudOperationsDao(dataSource);
    }

    @Override
    public void persist(AuthResource authResource) throws AuthServerException {
        this.transaction(connection -> {
            this.authResourceCrudOperationsDao.storeResource((Connection)connection, authResource);
            this.authResourceCrudOperationsDao.persistUserGroupMappings((Connection)connection, authResource.getResourceType(), authResource.getResourceName(), authResource.getActionsUserGroupsMap());
        });
    }

    @Override
    public void update(AuthResource authResource) throws AuthServerException {
        this.transaction(connection -> {
            this.authResourceCrudOperationsDao.updateOwner((Connection)connection, authResource.getResourceType(), authResource.getResourceName(), authResource.getOwner());
            this.authResourceCrudOperationsDao.deleteUserGroupMappings((Connection)connection, authResource.getResourceType(), authResource.getResourceName());
            this.authResourceCrudOperationsDao.persistUserGroupMappings((Connection)connection, authResource.getResourceType(), authResource.getResourceName(), authResource.getActionsUserGroupsMap());
        });
    }

    @Override
    public boolean delete(String resourceType, String resource) throws AuthServerException {
        return (Boolean)this.transaction(connection -> this.authResourceCrudOperationsDao.deleteResource((Connection)connection, resourceType, resource));
    }

    @Override
    public AuthResource read(String resourceType, String resourceName) throws AuthServerException {
        return (AuthResource)this.selectOperation(connection -> this.authResourceCrudOperationsDao.read((Connection)connection, resourceType, resourceName));
    }

    @Override
    public List<AuthResource> readAll(String resourceType, String ownerId) throws AuthServerException {
        return (List)this.selectOperation(connection -> this.authResourceCrudOperationsDao.readAll((Connection)connection, resourceType, ownerId));
    }

    @Override
    public List<AuthResource> readAll(String resourceType, String action, String ownerId, List<String> userGroups) throws AuthServerException {
        return (List)this.selectOperation(connection -> this.authResourceCrudOperationsDao.readAll((Connection)connection, resourceType, action, ownerId, userGroups));
    }

    @Override
    public boolean isExists(String resourceType, String resource) throws AuthServerException {
        return (Boolean)this.selectOperation(connection -> this.authResourceCrudOperationsDao.isExists((Connection)connection, resourceType, resource));
    }

    @Override
    public boolean updateOwner(String resourceType, String resourceName, String newOwner) throws AuthServerException {
        return (Boolean)this.transaction(connection -> this.authResourceCrudOperationsDao.updateOwner((Connection)connection, resourceType, resourceName, newOwner));
    }

    @Override
    public boolean addGroups(String resourceType, String resourceName, String action, List<String> groups) throws AuthServerException {
        return (Boolean)this.transaction(connection -> this.authResourceCrudOperationsDao.addGroups((Connection)connection, resourceType, resourceName, action, groups));
    }

    @Override
    public boolean removeGroup(String resourceType, String resourceName, String action, String group) throws AuthServerException {
        return (Boolean)this.transaction(connection -> this.authResourceCrudOperationsDao.removeGroup((Connection)connection, resourceType, resourceName, action, group));
    }

    private <E extends Exception> void transaction(ThrowingConsumer<Connection, E> command) throws AuthServerException {
        try {
            this.authResourceCrudOperationsDao.transaction(command);
        }
        catch (DaoException e) {
            throw new AuthServerException("Error occurred while executing transaction", e);
        }
    }

    private <R, E extends Exception> R transaction(ThrowingFunction<Connection, R, E> command) throws AuthServerException {
        try {
            return (R)this.authResourceCrudOperationsDao.transaction(command);
        }
        catch (DaoException e) {
            throw new AuthServerException("Error occurred while executing transaction", e);
        }
    }

    private <R, E extends Exception> R selectOperation(ThrowingFunction<Connection, R, E> command) throws AuthServerException {
        try {
            return (R)this.authResourceCrudOperationsDao.selectAndGetOperation(command);
        }
        catch (DaoException e) {
            throw new AuthServerException("Error occurred while executing transaction", e);
        }
    }
}

