/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authorization.provider;

import io.ballerina.messaging.broker.auth.AuthNotFoundException;
import io.ballerina.messaging.broker.auth.AuthServerException;
import io.ballerina.messaging.broker.auth.authorization.DiscretionaryAccessController;
import io.ballerina.messaging.broker.auth.authorization.UserStore;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.AuthResource;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.dao.AuthResourceDao;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.dao.impl.AuthResourceInMemoryDao;
import io.ballerina.messaging.broker.common.StartupContext;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryDacHandler
extends DiscretionaryAccessController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryDacHandler.class);
    private AuthResourceDao resourceDao = new AuthResourceInMemoryDao();

    @Override
    public void initialize(StartupContext startupContext, UserStore userStore, Map<String, String> properties) {
        try {
            this.persistDefaultAuthResources();
        }
        catch (AuthServerException e) {
            LOGGER.error("Error occurred while persisting auth resources.", (Throwable)e);
        }
    }

    @Override
    public void addResource(String resourceType, String resourceName, String owner) throws AuthServerException {
        this.resourceDao.persist(new AuthResource(resourceType, resourceName, false, owner));
    }

    @Override
    public boolean deleteResource(String resourceType, String resourceName) throws AuthServerException {
        return this.resourceDao.delete(resourceType, resourceName);
    }

    @Override
    public boolean addGroupsToResource(String resourceType, String resourceName, String action, List<String> groups) throws AuthServerException {
        return this.resourceDao.addGroups(resourceType, resourceName, action, groups);
    }

    @Override
    public boolean removeGroupFromResource(String resourceType, String resourceName, String action, String group) throws AuthServerException, AuthNotFoundException {
        return this.resourceDao.removeGroup(resourceType, resourceName, action, group);
    }

    @Override
    public boolean changeResourceOwner(String resourceType, String resourceName, String owner) throws AuthServerException {
        return this.resourceDao.updateOwner(resourceType, resourceName, owner);
    }

    @Override
    public AuthResource getAuthResource(String resourceType, String resourceName) throws AuthServerException {
        return this.resourceDao.read(resourceType, resourceName);
    }

    private void persistDefaultAuthResources() throws AuthServerException {
        this.addResource("exchange", "<<default>>", "admin");
        this.addResource("exchange", "amq.direct", "admin");
        this.addResource("exchange", "amq.topic", "admin");
        this.addResource("queue", "amq.dlq", "admin");
    }
}

