/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authorization.provider;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.ballerina.messaging.broker.auth.AuthNotFoundException;
import io.ballerina.messaging.broker.auth.AuthServerException;
import io.ballerina.messaging.broker.auth.BrokerAuthConfiguration;
import io.ballerina.messaging.broker.auth.authorization.DiscretionaryAccessController;
import io.ballerina.messaging.broker.auth.authorization.UserStore;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.AuthResource;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.ResourceCacheKey;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.dao.impl.AuthResourceRdbmsDao;
import io.ballerina.messaging.broker.common.StartupContext;
import io.ballerina.messaging.broker.common.config.BrokerConfigProvider;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.sql.DataSource;

public class RdbmsDacHandler
extends DiscretionaryAccessController {
    private LoadingCache<ResourceCacheKey, AuthResource> authResourceCache;
    private AuthResourceRdbmsDao authResourceDao;
    private UserStore userStore;

    @Override
    public void initialize(StartupContext startupContext, UserStore userStore, Map<String, String> properties) throws Exception {
        DataSource dataSource = (DataSource)startupContext.getService(DataSource.class);
        BrokerConfigProvider configProvider = (BrokerConfigProvider)startupContext.getService(BrokerConfigProvider.class);
        BrokerAuthConfiguration brokerAuthConfiguration = (BrokerAuthConfiguration)configProvider.getConfigurationObject("ballerina.broker.auth", BrokerAuthConfiguration.class);
        this.authResourceDao = new AuthResourceRdbmsDao(dataSource);
        this.userStore = userStore;
        this.authResourceCache = CacheBuilder.newBuilder().maximumSize((long)brokerAuthConfiguration.getAuthorization().getCache().getSize()).expireAfterWrite((long)brokerAuthConfiguration.getAuthorization().getCache().getTimeout(), TimeUnit.MINUTES).build((CacheLoader)new AuthResourceCacheLoader());
    }

    @Override
    public void addResource(String resourceType, String resourceName, String owner) throws AuthServerException {
        this.authResourceDao.persist(new AuthResource(resourceType, resourceName, true, owner));
    }

    @Override
    public boolean deleteResource(String resourceType, String resourceName) throws AuthServerException, AuthNotFoundException {
        AuthResource existingResource = this.getAuthResource(resourceType, resourceName);
        if (Objects.nonNull(existingResource)) {
            this.authResourceDao.delete(resourceType, resourceName);
            this.authResourceCache.invalidate((Object)new ResourceCacheKey(resourceType, resourceName));
        }
        return true;
    }

    @Override
    public AuthResource getAuthResource(String resourceType, String resourceName) throws AuthNotFoundException {
        try {
            return (AuthResource)this.authResourceCache.get((Object)new ResourceCacheKey(resourceType, resourceName));
        }
        catch (ExecutionException e) {
            throw new AuthNotFoundException("Error occurred while retrieving resource from cache for type : " + resourceType + "  name : " + resourceName, e);
        }
    }

    @Override
    public boolean changeResourceOwner(String resourceType, String resourceName, String newOwner) throws AuthServerException {
        boolean success = this.authResourceDao.updateOwner(resourceType, resourceName, newOwner);
        if (success) {
            this.authResourceCache.invalidate((Object)new ResourceCacheKey(resourceType, resourceName));
        }
        return success;
    }

    @Override
    public boolean addGroupsToResource(String resourceType, String resourceName, String action, List<String> groups) throws AuthServerException {
        boolean success = this.authResourceDao.addGroups(resourceType, resourceName, action, groups);
        if (success) {
            this.authResourceCache.invalidate((Object)new ResourceCacheKey(resourceType, resourceName));
        }
        return success;
    }

    @Override
    public boolean removeGroupFromResource(String resourceType, String resourceName, String action, String group) throws AuthServerException {
        boolean success = this.authResourceDao.removeGroup(resourceType, resourceName, action, group);
        if (success) {
            this.authResourceCache.invalidate((Object)new ResourceCacheKey(resourceType, resourceName));
        }
        return success;
    }

    private class AuthResourceCacheLoader
    extends CacheLoader<ResourceCacheKey, AuthResource> {
        private AuthResourceCacheLoader() {
        }

        public AuthResource load(@Nonnull ResourceCacheKey resourceCacheKey) throws AuthNotFoundException, AuthServerException {
            AuthResource authResource = RdbmsDacHandler.this.authResourceDao.read(resourceCacheKey.getResourceType(), resourceCacheKey.getResourceName());
            if (Objects.nonNull(authResource)) {
                return authResource;
            }
            throw new AuthNotFoundException("Resource does not found");
        }
    }
}

