/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.client.generator.util;

import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ballerinalang.client.generator.CodeGenerator;
import org.ballerinalang.client.generator.GeneratorConstants;
import org.ballerinalang.client.generator.exception.ClientGeneratorException;
import org.ballerinalang.client.generator.model.ClientContextHolder;
import org.ballerinalang.client.generator.model.FileDefinitionHolder;
import org.ballerinalang.client.generator.util.GeneratorUtils;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedAnnotationPackages;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.CompilationUnitNode;
import org.ballerinalang.model.tree.PackageNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

@SupportedAnnotationPackages(value={"ballerina/openapi"})
public class ClientGeneratorPlugin
extends AbstractCompilerPlugin {
    List<BLangSimpleVariable> endpoints;

    public void init(DiagnosticLog diagnosticLog) {
        this.endpoints = new ArrayList<BLangSimpleVariable>();
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        PrintStream err = System.err;
        AnnotationAttachmentNode config = GeneratorUtils.getAnnotationFromList("ClientConfig", "openapi", annotations);
        if (this.isClientGenerationEnabled(config)) {
            try {
                ClientContextHolder context = ClientContextHolder.buildContext((BLangService)serviceNode, this.endpoints);
                String fileName = serviceNode.getName().getValue().toLowerCase(Locale.ENGLISH) + "_client.bal";
                String generatedSource = CodeGenerator.generateOutput(GeneratorConstants.GenType.CLIENT, context);
                FileDefinitionHolder.getInstance().addDefinition(fileName, generatedSource);
            }
            catch (ClientGeneratorException e) {
                err.println("Client code was not generated: " + e.getMessage());
            }
        }
    }

    public void process(PackageNode packageNode) {
        for (CompilationUnitNode compilationUnitNode : packageNode.getCompilationUnits()) {
            for (TopLevelNode topLevelNode : compilationUnitNode.getTopLevelNodes()) {
                if (!(topLevelNode instanceof BLangSimpleVariable) || !((BLangSimpleVariable)topLevelNode).getFlags().contains(Flag.LISTENER) || !this.isAnClientEnabledEndpoint((BLangSimpleVariable)topLevelNode)) continue;
                this.endpoints.add((BLangSimpleVariable)topLevelNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void codeGenerated(PackageID packageID, Path binaryPath) {
        PrintStream err = System.err;
        Map<String, String> definitionMap = FileDefinitionHolder.getInstance().getFileDefinitionMap();
        if (binaryPath == null) {
            err.print("Error while generating client for the service. Binary file path is null");
            return;
        }
        Path filePath = binaryPath.toAbsolutePath();
        Path parentDirPath = filePath.getParent();
        if (parentDirPath == null) {
            parentDirPath = filePath;
        }
        Path targetDirPath = Paths.get(parentDirPath.toString(), "client");
        for (Map.Entry<String, String> entry : definitionMap.entrySet()) {
            try {
                CodeGenerator.writeFile(targetDirPath, entry.getKey(), entry.getValue());
            }
            catch (ClientGeneratorException e) {
                err.print(e.getMessage());
            }
            finally {
                FileDefinitionHolder.getInstance().removeFileDefinition(entry.getKey());
            }
        }
    }

    private boolean isClientGenerationEnabled(AnnotationAttachmentNode ann) {
        if (ann == null) {
            return false;
        }
        BLangRecordLiteral bLiteral = (BLangRecordLiteral)((BLangAnnotationAttachment)ann).getExpression();
        Map<String, String[]> attrs = GeneratorUtils.getKeyValuePairAsMap(bLiteral.getFields());
        String val = attrs.get("generate")[0];
        boolean isClientRequested = Boolean.parseBoolean(val);
        return isClientRequested;
    }

    private boolean isAnClientEnabledEndpoint(BLangSimpleVariable endpoint) {
        boolean isClientEnabledEndpoint = false;
        for (BLangAnnotationAttachment annAttachment : endpoint.annAttachments) {
            if (!annAttachment.annotationName.getValue().equals("ClientEndpoint")) continue;
            isClientEnabledEndpoint = true;
            break;
        }
        return isClientEnabledEndpoint;
    }
}

