/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.tcp;

import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.stdlib.socket.tcp.SelectorDispatcher;
import org.ballerinalang.stdlib.socket.tcp.SocketService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPSocketCallback
implements CallableUnitCallback {
    private static final Logger log = LoggerFactory.getLogger(TCPSocketCallback.class);
    private SocketService socketService;
    private boolean executeFailureOnce = false;

    public TCPSocketCallback(SocketService socketService) {
        this.socketService = socketService;
    }

    public TCPSocketCallback(SocketService socketService, boolean executeFailureOnce) {
        this.socketService = socketService;
        this.executeFailureOnce = executeFailureOnce;
    }

    public void notifySuccess() {
        log.debug("Socket resource dispatch succeed.");
    }

    public void notifyFailure(ErrorValue error) {
        String errorMsg = error.stringValue();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Socket resource dispatch failed: %s", errorMsg));
        }
        if (!this.executeFailureOnce) {
            SelectorDispatcher.invokeOnError(this.socketService, new TCPSocketCallback(this.socketService, true), error);
        } else {
            log.error(String.format("NotifyFailure hit twice, hence preventing error dispatching. Cause: %s", errorMsg));
        }
    }
}

