/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.task;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.BuildContextField;
import org.ballerinalang.packerina.task.Task;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;

public class CopyResourcesTask
implements Task {
    @Override
    public void execute(BuildContext buildContext) {
        Path sourceRoot = (Path)buildContext.get(BuildContextField.SOURCE_ROOT);
        List<BLangPackage> moduleBirMap = buildContext.getModules();
        for (BLangPackage module : moduleBirMap) {
            this.copyResourcesToJar(buildContext, sourceRoot, module);
        }
    }

    private void copyResourcesToJar(BuildContext buildContext, Path sourceRootPath, BLangPackage module) {
        Path resourceDir = sourceRootPath.resolve("src").resolve(module.packageID.name.value).resolve("resources");
        if (!resourceDir.toFile().exists()) {
            return;
        }
        Path moduleJarPath = buildContext.getJarPathFromTargetCache(module.packageID);
        URI uberJarUri = URI.create("jar:" + moduleJarPath.toUri().toString());
        try (FileSystem toFs = FileSystems.newFileSystem(uberJarUri, Collections.emptyMap());){
            Path to = toFs.getRootDirectories().iterator().next().resolve("resources").resolve(module.packageID.orgName.value).resolve(module.packageID.name.value);
            Files.walkFileTree(resourceDir, new Copy(resourceDir, to));
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)("error while adding resources to module jar :" + e.getMessage()));
        }
    }

    static class Copy
    extends SimpleFileVisitor<Path> {
        private Path fromPath;
        private Path toPath;
        private StandardCopyOption copyOption;

        Copy(Path fromPath, Path toPath, StandardCopyOption copyOption) {
            this.fromPath = fromPath;
            this.toPath = toPath;
            this.copyOption = copyOption;
        }

        Copy(Path fromPath, Path toPath) {
            this(fromPath, toPath, StandardCopyOption.REPLACE_EXISTING);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.toPath.resolve(this.fromPath.relativize(dir).toString());
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectories(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path toFile = this.toPath.resolve(this.fromPath.relativize(file).toString());
            Files.copy(file, toFile, this.copyOption);
            return FileVisitResult.CONTINUE;
        }
    }
}

