/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.task;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.ballerinalang.docgen.docs.BallerinaDocGenerator;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.BuildContextField;
import org.ballerinalang.packerina.task.Task;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;

public class CreateDocsTask
implements Task {
    private boolean excludeIndex;
    private boolean toJson;
    private Path jsonPath;

    public CreateDocsTask(boolean toJson, Path jsonPath, boolean excludeIndex) {
        this.excludeIndex = excludeIndex;
        this.toJson = toJson;
        this.jsonPath = jsonPath;
    }

    @Override
    public void execute(BuildContext buildContext) {
        Path sourceRootPath = (Path)buildContext.get(BuildContextField.SOURCE_ROOT);
        Path targetDir = (Path)buildContext.get(BuildContextField.TARGET_DIR);
        Path outputPath = targetDir.resolve("apidocs");
        buildContext.out().println();
        if (this.jsonPath != null) {
            buildContext.out().println("Generating API Documentation using data in JSON");
            BallerinaDocGenerator.writeAPIDocsForModulesFromJson((Path)this.jsonPath, (String)outputPath.toString(), (boolean)this.excludeIndex);
            buildContext.out().println("\t" + sourceRootPath.relativize(outputPath).toString());
        } else {
            buildContext.out().println("Generating API Documentation");
            List<BLangPackage> modules = buildContext.getModules();
            try {
                BallerinaDocGenerator.setPrintStream((PrintStream)new EmptyPrintStream());
                Map moduleDocMap = BallerinaDocGenerator.generateModuleDocsFromBLangPackages((String)sourceRootPath.toString(), modules);
                Files.createDirectories(outputPath, new FileAttribute[0]);
                if (this.toJson) {
                    BallerinaDocGenerator.writeAPIDocsToJSON((Map)moduleDocMap, (String)outputPath.toString());
                    buildContext.out().println("\tdata saved as a JSON in: " + sourceRootPath.relativize(outputPath).toString());
                } else {
                    BallerinaDocGenerator.writeAPIDocsForModules((Map)moduleDocMap, (String)outputPath.toString(), (boolean)this.excludeIndex);
                    buildContext.out().println("\t" + sourceRootPath.relativize(outputPath).toString());
                }
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)"Unable to generate API Documentation.");
            }
        }
    }

    static class EmptyPrintStream
    extends PrintStream {
        EmptyPrintStream() throws UnsupportedEncodingException {
            super(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }, true, "UTF-8");
        }
    }
}

