/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.writer;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.CompiledPackage;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.programfile.CompiledBinaryFile;
import org.wso2.ballerinalang.programfile.PackageFileWriter;

public class BirFileWriter {
    private static final CompilerContext.Key<BirFileWriter> BIR_FILE_WRITER_KEY = new CompilerContext.Key();

    public static BirFileWriter getInstance(CompilerContext context) {
        BirFileWriter binaryFileWriter = (BirFileWriter)context.get(BIR_FILE_WRITER_KEY);
        if (binaryFileWriter == null) {
            binaryFileWriter = new BirFileWriter(context);
        }
        return binaryFileWriter;
    }

    private BirFileWriter(CompilerContext context) {
        context.put(BIR_FILE_WRITER_KEY, (Object)this);
    }

    public void write(BLangPackage module, Path birFilePath) {
        BPackageSymbol symbol = module.symbol;
        CompiledPackage compiledPackage = symbol.compiledPackage;
        if (compiledPackage.getKind() == CompiledPackage.Kind.FROM_BINARY) {
            return;
        }
        this.writeBIRToProjectCache(module, birFilePath);
    }

    private void writeBIRToProjectCache(BLangPackage module, Path birFilePath) {
        if (module.symbol.birPackageFile == null) {
            return;
        }
        try {
            byte[] pkgBirBinaryContent = PackageFileWriter.writePackage((CompiledBinaryFile.BIRPackageFile)module.symbol.birPackageFile);
            Files.write(birFilePath, pkgBirBinaryContent, new OpenOption[0]);
        }
        catch (IOException e) {
            String msg = "error writing the compiled module(bir) of '" + module.packageID + "' to '" + birFilePath + "': " + e.getMessage();
            throw new BLangCompilerException(msg, (Throwable)e);
        }
    }

    public void writeBIRToPath(CompiledBinaryFile.BIRPackageFile birPackageFile, PackageID id, Path birFilePath) {
        try {
            byte[] pkgBirBinaryContent = PackageFileWriter.writePackage((CompiledBinaryFile.BIRPackageFile)birPackageFile);
            Files.write(birFilePath, pkgBirBinaryContent, new OpenOption[0]);
        }
        catch (IOException e) {
            String msg = "error writing the compiled module(bir) of '" + id + "' to '" + birFilePath + "': " + e.getMessage();
            throw new BLangCompilerException(msg, (Throwable)e);
        }
    }
}

