/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.writer;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.packerina.model.LockFilePackage;
import org.ballerinalang.toml.model.Manifest;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.RepoUtils;

public class LockFileWriter {
    private static final CompilerContext.Key<LockFileWriter> LOCK_FILE_WRITER_KEY = new CompilerContext.Key();
    private final SourceDirectory sourceDirectory;
    private TreeMap<PackageID, LockFilePackage> ballerinaLockPackages = new TreeMap(Comparator.comparing(p -> p.orgName.value).thenComparing(p -> p.name.value).thenComparing(p -> p.version.value));
    private List<String> entryPackages = new ArrayList<String>();

    private LockFileWriter(CompilerContext context) {
        context.put(LOCK_FILE_WRITER_KEY, (Object)this);
        this.sourceDirectory = (SourceDirectory)context.get(SourceDirectory.class);
        if (this.sourceDirectory == null) {
            throw new IllegalArgumentException("source directory has not been initialized");
        }
    }

    public static LockFileWriter getInstance(CompilerContext context) {
        LockFileWriter lockFileWriter = (LockFileWriter)context.get(LOCK_FILE_WRITER_KEY);
        if (lockFileWriter == null) {
            lockFileWriter = new LockFileWriter(context);
        }
        return lockFileWriter;
    }

    public void addEntryPkg(BPackageSymbol packageSymbol) {
        String entryPkg = packageSymbol.pkgID.name.value;
        if (packageSymbol.pkgID.isUnnamed) {
            entryPkg = packageSymbol.pkgID.sourceFileName.value;
        }
        this.entryPackages.add(entryPkg);
        this.getPkgDependencies(packageSymbol);
    }

    private void getPkgDependencies(BPackageSymbol packageSymbol) {
        LockFilePackage lockFilePackage = new LockFilePackage(packageSymbol.pkgID.orgName.value, packageSymbol.pkgID.name.value, packageSymbol.pkgID.version.value);
        if (packageSymbol.pkgID.isUnnamed) {
            lockFilePackage = new LockFilePackage(packageSymbol.pkgID.orgName.value, packageSymbol.pkgID.sourceFileName.value, packageSymbol.pkgID.version.value);
        }
        List<BPackageSymbol> importPackages = this.getImportPackages(packageSymbol);
        lockFilePackage.setDependencyPackages(this.getImports(importPackages));
        this.ballerinaLockPackages.put(packageSymbol.pkgID, lockFilePackage);
        if (importPackages.size() > 0) {
            for (BPackageSymbol importPackage : importPackages) {
                this.getPkgDependencies(importPackage);
            }
        }
    }

    private List<LockFilePackage> getImports(List<BPackageSymbol> packageSymbols) {
        return packageSymbols.stream().map(symbol -> new LockFilePackage(symbol.pkgID.orgName.value, symbol.pkgID.name.value, symbol.pkgID.version.value)).collect(Collectors.toList());
    }

    private List<BPackageSymbol> getImportPackages(BPackageSymbol packageNode) {
        return packageNode.imports.stream().filter(pkg -> !pkg.pkgID.orgName.value.equals("ballerina")).collect(Collectors.toList());
    }

    private StringBuilder generateProjectDesc(Manifest manifest) {
        return new StringBuilder().append("[project]").append("\n").append("name").append(" = ").append(String.format("\"%s\"", manifest.getProject().getOrgName())).append("\n").append("version").append(" = ").append(String.format("\"%s\"", manifest.getProject().getVersion())).append("\n").append("lockfileversion").append(" = ").append(String.format("\"%s\"", "1")).append("\n").append("ballerinaversion").append(" = ").append(String.format("\"%s\"", RepoUtils.getBallerinaVersion())).append("\n").append("modules").append(" = [").append(this.entryPackages.stream().map(str -> " \"" + str + "\" ").collect(Collectors.joining(","))).append("]\n");
    }

    public void writeLockFile(Manifest manifest) {
        ArrayList<StringBuilder> builderList = new ArrayList<StringBuilder>();
        for (LockFilePackage lockFilePackage : this.ballerinaLockPackages.values()) {
            StringBuilder builder = new StringBuilder().append("[[").append("module").append("]] \n");
            if (!(lockFilePackage.getOrg().isEmpty() || lockFilePackage.getOrg().equals(Names.DEFAULT_PACKAGE.getValue()) || lockFilePackage.getOrg().equals(Names.ANON_ORG.getValue()))) {
                builder.append("org").append(" = ").append(String.format("\"%s\"", lockFilePackage.getOrg())).append("\n");
            }
            builder.append("name").append(" = ").append(String.format("\"%s\"", lockFilePackage.getName())).append("\n");
            if (!lockFilePackage.getVersion().isEmpty() && !lockFilePackage.getVersion().equals(Names.DEFAULT_VERSION.getValue())) {
                builder.append("version").append(" = ").append(String.format("\"%s\"", lockFilePackage.getVersion())).append("\n");
            }
            if (!lockFilePackage.getDependencies().isEmpty()) {
                builder.append("imports").append(" = [").append(lockFilePackage.getDependencies().stream().map(this::getImportAsString).collect(Collectors.joining(","))).append("]").append("\n");
            } else {
                builder.append("");
            }
            builderList.add(builder);
        }
        Path ballerinaLockFilePath = this.sourceDirectory.getPath().resolve(Paths.get("Ballerina.lock", new String[0]));
        builderList.add(0, this.generateProjectDesc(manifest));
        StringBuilder sb = new StringBuilder(builderList.size() * 10);
        for (StringBuilder line : builderList) {
            sb.append((CharSequence)line);
            sb.append("\n");
        }
        try {
            Files.write(ballerinaLockFilePath, sb.toString().getBytes(Charset.defaultCharset()), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getImportAsString(LockFilePackage lockFilePackage) {
        return "{org=\"" + lockFilePackage.getOrg() + "\", " + "name" + "=\"" + lockFilePackage.getName() + "\"," + "version" + "=\"" + lockFilePackage.getVersion() + "\"}";
    }
}

