/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.nativeimpl.consumer;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.messaging.kafka.observability.KafkaMetricsUtil;
import org.ballerinalang.messaging.kafka.observability.KafkaTracingUtil;
import org.ballerinalang.messaging.kafka.utils.KafkaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerInformationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerInformationHandler.class);
    private static final BArrayType stringArrayType = new BArrayType(BTypes.typeString);

    public static Object assign(ObjectValue consumerObject, BArray topicPartitions) {
        KafkaTracingUtil.traceResourceInvocation(Scheduler.getStrand(), consumerObject);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)consumerObject.getNativeData("KafkaConsumer");
        ArrayList<TopicPartition> partitions = KafkaUtils.getTopicPartitionList(topicPartitions, logger);
        try {
            kafkaConsumer.assign(partitions);
        }
        catch (IllegalArgumentException | IllegalStateException | KafkaException e) {
            KafkaMetricsUtil.reportConsumerError(consumerObject, "assign");
            return KafkaUtils.createKafkaError("Failed to assign topics for the consumer: " + e.getMessage(), "{ballerina/kafka}ConsumerError");
        }
        return null;
    }

    public static Object getAssignment(ObjectValue consumerObject) {
        KafkaTracingUtil.traceResourceInvocation(Scheduler.getStrand(), consumerObject);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)consumerObject.getNativeData("KafkaConsumer");
        BArray topicPartitionArray = BValueCreator.createArrayValue((BArrayType)new BArrayType(KafkaUtils.getTopicPartitionRecord().getType()));
        try {
            Set topicPartitions = kafkaConsumer.assignment();
            for (TopicPartition partition : topicPartitions) {
                MapValue<String, Object> tp = KafkaUtils.populateTopicPartitionRecord(partition.topic(), partition.partition());
                topicPartitionArray.append(tp);
            }
            return topicPartitionArray;
        }
        catch (KafkaException e) {
            KafkaMetricsUtil.reportConsumerError(consumerObject, "get_assignment");
            return KafkaUtils.createKafkaError("Failed to retrieve assignment for the consumer: " + e.getMessage(), "{ballerina/kafka}ConsumerError");
        }
    }

    public static Object getAvailableTopics(ObjectValue consumerObject, long duration) {
        KafkaTracingUtil.traceResourceInvocation(Scheduler.getStrand(), consumerObject);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)consumerObject.getNativeData("KafkaConsumer");
        Properties consumerProperties = (Properties)consumerObject.getNativeData("KafkaConsumerConfig");
        int defaultApiTimeout = KafkaUtils.getDefaultApiTimeout(consumerProperties);
        int apiTimeout = KafkaUtils.getIntFromLong(duration, logger, "duration");
        try {
            Map<String, List<PartitionInfo>> topics = apiTimeout > -1 ? ConsumerInformationHandler.getAvailableTopicWithDuration(kafkaConsumer, apiTimeout) : (defaultApiTimeout > -1 ? ConsumerInformationHandler.getAvailableTopicWithDuration(kafkaConsumer, defaultApiTimeout) : kafkaConsumer.listTopics());
            return ConsumerInformationHandler.getBArrayFromMap(topics);
        }
        catch (KafkaException e) {
            KafkaMetricsUtil.reportConsumerError(consumerObject, "get_topics");
            return KafkaUtils.createKafkaError("Failed to retrieve available topics: " + e.getMessage(), "{ballerina/kafka}ConsumerError");
        }
    }

    public static Object getPausedPartitions(ObjectValue consumerObject) {
        KafkaTracingUtil.traceResourceInvocation(Scheduler.getStrand(), consumerObject);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)consumerObject.getNativeData("KafkaConsumer");
        BArray topicPartitionArray = BValueCreator.createArrayValue((BArrayType)new BArrayType(KafkaUtils.getTopicPartitionRecord().getType()));
        try {
            Set pausedPartitions = kafkaConsumer.paused();
            for (TopicPartition partition : pausedPartitions) {
                MapValue<String, Object> tp = KafkaUtils.populateTopicPartitionRecord(partition.topic(), partition.partition());
                topicPartitionArray.append(tp);
            }
            return topicPartitionArray;
        }
        catch (KafkaException e) {
            KafkaMetricsUtil.reportConsumerError(consumerObject, "get_paused_partitions");
            return KafkaUtils.createKafkaError("Failed to retrieve paused partitions: " + e.getMessage(), "{ballerina/kafka}ConsumerError");
        }
    }

    public static Object getTopicPartitions(ObjectValue consumerObject, String topic, long duration) {
        KafkaTracingUtil.traceResourceInvocation(Scheduler.getStrand(), consumerObject);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)consumerObject.getNativeData("KafkaConsumer");
        Properties consumerProperties = (Properties)consumerObject.getNativeData("KafkaConsumerConfig");
        int defaultApiTimeout = KafkaUtils.getDefaultApiTimeout(consumerProperties);
        int apiTimeout = KafkaUtils.getIntFromLong(duration, logger, "duration");
        try {
            List<PartitionInfo> partitionInfoList = apiTimeout > -1 ? ConsumerInformationHandler.getPartitionInfoList(kafkaConsumer, topic, apiTimeout) : (defaultApiTimeout > -1 ? ConsumerInformationHandler.getPartitionInfoList(kafkaConsumer, topic, defaultApiTimeout) : kafkaConsumer.partitionsFor(topic));
            BArray topicPartitionArray = BValueCreator.createArrayValue((BArrayType)new BArrayType(KafkaUtils.getTopicPartitionRecord().getType()));
            for (PartitionInfo info : partitionInfoList) {
                MapValue<String, Object> partition = KafkaUtils.populateTopicPartitionRecord(info.topic(), info.partition());
                topicPartitionArray.append(partition);
            }
            return topicPartitionArray;
        }
        catch (KafkaException e) {
            KafkaMetricsUtil.reportConsumerError(consumerObject, "get_topic_partitions");
            return KafkaUtils.createKafkaError("Failed to retrieve topic partitions for the consumer: " + e.getMessage(), "{ballerina/kafka}ConsumerError");
        }
    }

    public static Object getSubscription(ObjectValue consumerObject) {
        KafkaTracingUtil.traceResourceInvocation(Scheduler.getStrand(), consumerObject);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)consumerObject.getNativeData("KafkaConsumer");
        try {
            Set subscriptions = kafkaConsumer.subscription();
            BArray arrayValue = BValueCreator.createArrayValue((BArrayType)stringArrayType);
            if (!subscriptions.isEmpty()) {
                for (String subscription : subscriptions) {
                    arrayValue.append((Object)subscription);
                }
            }
            return arrayValue;
        }
        catch (KafkaException e) {
            KafkaMetricsUtil.reportConsumerError(consumerObject, "get_subscription");
            return KafkaUtils.createKafkaError("Failed to retrieve subscribed topics: " + e.getMessage(), "{ballerina/kafka}ConsumerError");
        }
    }

    private static Map<String, List<PartitionInfo>> getAvailableTopicWithDuration(KafkaConsumer kafkaConsumer, long timeout) {
        Duration duration = Duration.ofMillis(timeout);
        return kafkaConsumer.listTopics(duration);
    }

    private static BArray getBArrayFromMap(Map<String, List<PartitionInfo>> map) {
        BArray bArray = BValueCreator.createArrayValue((BArrayType)new BArrayType(BTypes.typeString));
        if (!map.keySet().isEmpty()) {
            for (String topic : map.keySet()) {
                bArray.append((Object)topic);
            }
        }
        return bArray;
    }

    private static List<PartitionInfo> getPartitionInfoList(KafkaConsumer kafkaConsumer, String topic, long timeout) {
        Duration duration = Duration.ofMillis(timeout);
        return kafkaConsumer.partitionsFor(topic, duration);
    }
}

