/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.nativeimpl.consumer;

import java.time.Duration;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.KafkaException;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.messaging.kafka.observability.KafkaMetricsUtil;
import org.ballerinalang.messaging.kafka.observability.KafkaTracingUtil;
import org.ballerinalang.messaging.kafka.utils.KafkaUtils;

public class Poll {
    public static Object poll(ObjectValue consumerObject, long timeout) {
        Strand strand = Scheduler.getStrand();
        KafkaTracingUtil.traceResourceInvocation(strand, consumerObject);
        NonBlockingCallback callback = new NonBlockingCallback(strand);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)consumerObject.getNativeData("KafkaConsumer");
        String keyType = consumerObject.getStringValue("keyDeserializerType");
        String valueType = consumerObject.getStringValue("valueDeserializerType");
        Duration duration = Duration.ofMillis(timeout);
        BArray consumerRecordsArray = BValueCreator.createArrayValue((BArrayType)new BArrayType(KafkaUtils.getConsumerRecord().getType()));
        try {
            ConsumerRecords recordsRetrieved = kafkaConsumer.poll(duration);
            if (!recordsRetrieved.isEmpty()) {
                for (Object record : recordsRetrieved) {
                    MapValue<String, Object> recordValue = KafkaUtils.populateConsumerRecord((ConsumerRecord)record, keyType, valueType);
                    consumerRecordsArray.append(recordValue);
                    KafkaMetricsUtil.reportConsume(consumerObject, recordValue.getStringValue("topic"), recordValue.get((Object)"value"));
                }
            }
            callback.setReturnValues((Object)consumerRecordsArray);
        }
        catch (IllegalArgumentException | IllegalStateException | KafkaException e) {
            KafkaMetricsUtil.reportConsumerError(consumerObject, "poll");
            callback.notifyFailure(KafkaUtils.createKafkaError("Failed to poll from the Kafka server: " + e.getMessage(), "{ballerina/kafka}ConsumerError"));
        }
        callback.notifySuccess();
        return null;
    }
}

