/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.nativeimpl.consumer;

import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.values.FPValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.messaging.kafka.observability.KafkaMetricsUtil;
import org.ballerinalang.messaging.kafka.observability.KafkaTracingUtil;
import org.ballerinalang.messaging.kafka.utils.KafkaUtils;

public class SubscriptionHandler {
    private static final PrintStream console = System.out;

    public static Object subscribe(ObjectValue consumerObject, BArray topics) {
        KafkaTracingUtil.traceResourceInvocation(Scheduler.getStrand(), consumerObject);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)consumerObject.getNativeData("KafkaConsumer");
        List<String> topicsList = KafkaUtils.getStringListFromStringBArray(topics);
        try {
            kafkaConsumer.subscribe(topicsList);
            Set subscribedTopics = kafkaConsumer.subscription();
            KafkaMetricsUtil.reportBulkSubscription(consumerObject, subscribedTopics);
        }
        catch (IllegalArgumentException | IllegalStateException | KafkaException e) {
            KafkaMetricsUtil.reportConsumerError(consumerObject, "subscribe");
            return KafkaUtils.createKafkaError("Failed to subscribe to the provided topics: " + e.getMessage(), "{ballerina/kafka}ConsumerError");
        }
        console.println("[ballerina/kafka] subscribed topics: " + KafkaUtils.getTopicNamesString(topicsList));
        return null;
    }

    public static Object subscribeToPattern(ObjectValue consumerObject, String topicRegex) {
        KafkaTracingUtil.traceResourceInvocation(Scheduler.getStrand(), consumerObject);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)consumerObject.getNativeData("KafkaConsumer");
        try {
            kafkaConsumer.subscribe(Pattern.compile(topicRegex));
            Set topicsList = kafkaConsumer.subscription();
            KafkaMetricsUtil.reportBulkSubscription(consumerObject, topicsList);
        }
        catch (IllegalArgumentException | IllegalStateException | KafkaException e) {
            KafkaMetricsUtil.reportConsumerError(consumerObject, "subscribe_to_pattern");
            return KafkaUtils.createKafkaError("Failed to unsubscribe from the topics: " + e.getMessage(), "{ballerina/kafka}ConsumerError");
        }
        return null;
    }

    public static Object subscribeWithPartitionRebalance(ObjectValue consumerObject, BArray topics, FPValue onPartitionsRevoked, FPValue onPartitionsAssigned) {
        Strand strand = Scheduler.getStrand();
        KafkaTracingUtil.traceResourceInvocation(strand, consumerObject);
        NonBlockingCallback callback = new NonBlockingCallback(strand);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)consumerObject.getNativeData("KafkaConsumer");
        List<String> topicsList = KafkaUtils.getStringListFromStringBArray(topics);
        KafkaRebalanceListener consumer = new KafkaRebalanceListener(strand, strand.scheduler, onPartitionsRevoked, onPartitionsAssigned, consumerObject);
        try {
            kafkaConsumer.subscribe(topicsList, (ConsumerRebalanceListener)consumer);
            Set subscribedTopics = kafkaConsumer.subscription();
            KafkaMetricsUtil.reportBulkSubscription(consumerObject, subscribedTopics);
        }
        catch (IllegalArgumentException | IllegalStateException | KafkaException e) {
            KafkaMetricsUtil.reportConsumerError(consumerObject, "subscribe_with_partition_rebalance");
            callback.notifyFailure(KafkaUtils.createKafkaError("Failed to subscribe the consumer: " + e.getMessage(), "{ballerina/kafka}ConsumerError"));
        }
        callback.notifySuccess();
        return null;
    }

    public static Object unsubscribe(ObjectValue consumerObject) {
        KafkaTracingUtil.traceResourceInvocation(Scheduler.getStrand(), consumerObject);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)consumerObject.getNativeData("KafkaConsumer");
        try {
            Set topics = kafkaConsumer.subscription();
            kafkaConsumer.unsubscribe();
            KafkaMetricsUtil.reportBulkUnsubscription(consumerObject, topics);
        }
        catch (KafkaException e) {
            KafkaMetricsUtil.reportConsumerError(consumerObject, "unsubscribe");
            return KafkaUtils.createKafkaError("Failed to unsubscribe the consumer: " + e.getMessage(), "{ballerina/kafka}ConsumerError");
        }
        return null;
    }

    static class KafkaRebalanceListener
    implements ConsumerRebalanceListener {
        private Strand strand;
        private Scheduler scheduler;
        private FPValue onPartitionsRevoked;
        private FPValue onPartitionsAssigned;
        private ObjectValue consumer;

        KafkaRebalanceListener(Strand strand, Scheduler scheduler, FPValue onPartitionsRevoked, FPValue onPartitionsAssigned, ObjectValue consumer) {
            this.strand = strand;
            this.scheduler = scheduler;
            this.onPartitionsRevoked = onPartitionsRevoked;
            this.onPartitionsAssigned = onPartitionsAssigned;
            this.consumer = consumer;
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            Object[] inputArgs = new Object[]{null, this.consumer, true, this.getPartitionsArray(partitions), true};
            this.scheduler.schedule(inputArgs, this.onPartitionsRevoked.getConsumer(), this.strand, null);
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            Object[] inputArgs = new Object[]{null, this.consumer, true, this.getPartitionsArray(partitions), true};
            this.scheduler.schedule(inputArgs, this.onPartitionsAssigned.getConsumer(), this.strand, null);
        }

        private BArray getPartitionsArray(Collection<TopicPartition> partitions) {
            BArray topicPartitionArray = BValueCreator.createArrayValue((BArrayType)new BArrayType(KafkaUtils.getTopicPartitionRecord().getType()));
            for (TopicPartition partition : partitions) {
                MapValue<String, Object> topicPartition = KafkaUtils.populateTopicPartitionRecord(partition.topic(), partition.partition());
                topicPartitionArray.append(topicPartition);
            }
            return topicPartitionArray;
        }
    }
}

