/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.nativeimpl.producer;

import org.apache.kafka.clients.producer.ProducerRecord;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.messaging.kafka.nativeimpl.producer.Send;
import org.ballerinalang.messaging.kafka.utils.KafkaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendCustomValues
extends Send {
    private static final Logger logger = LoggerFactory.getLogger(SendCustomValues.class);

    public static Object sendCustomValuesNilKeys(ObjectValue producer, Object value, String topic, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, null, value);
        return SendCustomValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendCustomValuesStringKeys(ObjectValue producer, Object value, String topic, String key, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)key, value);
        return SendCustomValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendCustomValuesIntKeys(ObjectValue producer, Object value, String topic, long key, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)key, value);
        return SendCustomValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendCustomValuesFloatKeys(ObjectValue producer, Object value, String topic, double key, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)key, value);
        return SendCustomValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendCustomValuesByteArrayKeys(ObjectValue producer, Object value, String topic, BArray key, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)key.getBytes(), value);
        return SendCustomValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendCustomValuesCustomKeys(ObjectValue producer, Object value, String topic, Object key, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, key, value);
        return SendCustomValues.sendKafkaRecord(kafkaRecord, producer);
    }
}

