/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.observability;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.observability.metrics.DefaultMetricRegistry;
import org.ballerinalang.jvm.observability.metrics.MetricId;
import org.ballerinalang.jvm.observability.metrics.MetricRegistry;
import org.ballerinalang.jvm.observability.metrics.StatisticConfig;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.messaging.kafka.observability.KafkaObservabilityConstants;
import org.ballerinalang.messaging.kafka.observability.KafkaObserverContext;
import org.ballerinalang.messaging.kafka.utils.KafkaUtils;
import org.slf4j.LoggerFactory;

public class KafkaMetricsUtil {
    private static final MetricRegistry metricRegistry = DefaultMetricRegistry.getInstance();

    public static void reportNewProducer(ObjectValue producerObject) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        KafkaObserverContext observerContext = new KafkaObserverContext("producer", KafkaUtils.getClientId(producerObject), KafkaUtils.getBootstrapServers(producerObject));
        KafkaMetricsUtil.incrementGauge(observerContext, KafkaObservabilityConstants.METRIC_PUBLISHERS[0], KafkaObservabilityConstants.METRIC_PUBLISHERS[1]);
    }

    public static void reportNewConsumer(ObjectValue consumerObject) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        KafkaObserverContext observerContext = new KafkaObserverContext("consumer", KafkaUtils.getClientId(consumerObject), KafkaUtils.getBootstrapServers(consumerObject));
        KafkaMetricsUtil.incrementGauge(observerContext, KafkaObservabilityConstants.METRIC_CONSUMERS[0], KafkaObservabilityConstants.METRIC_CONSUMERS[1]);
    }

    public static void reportProducerClose(ObjectValue producerObject) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        KafkaObserverContext observerContext = new KafkaObserverContext("producer", KafkaUtils.getClientId(producerObject), KafkaUtils.getBootstrapServers(producerObject));
        KafkaMetricsUtil.decrementGauge(observerContext, KafkaObservabilityConstants.METRIC_PUBLISHERS[0], KafkaObservabilityConstants.METRIC_PUBLISHERS[1]);
    }

    public static void reportConsumerClose(ObjectValue consumerObject) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        KafkaObserverContext observerContext = new KafkaObserverContext("consumer", KafkaUtils.getClientId(consumerObject), KafkaUtils.getBootstrapServers(consumerObject));
        KafkaMetricsUtil.decrementGauge(observerContext, KafkaObservabilityConstants.METRIC_CONSUMERS[0], KafkaObservabilityConstants.METRIC_CONSUMERS[1]);
    }

    public static void reportPublish(ObjectValue producerObject, String topic, Object value) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        KafkaObserverContext observerContext = new KafkaObserverContext("producer", KafkaUtils.getClientId(producerObject), KafkaUtils.getBootstrapServers(producerObject), topic);
        int size = KafkaMetricsUtil.getMessageSize(value);
        KafkaMetricsUtil.reportPublish(observerContext, size);
    }

    private static int getMessageSize(Object message) {
        int size = 0;
        if (message instanceof String) {
            byte[] bytes = ((String)message).getBytes(StandardCharsets.UTF_8);
            size = bytes.length;
        } else if (message instanceof Long || message instanceof Double) {
            size = 8;
        } else if (message instanceof byte[]) {
            size = ((byte[])message).length;
        } else {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(message);
                oos.flush();
                byte[] data = bos.toByteArray();
                size = data.length;
            }
            catch (IOException e) {
                LoggerFactory.getLogger(KafkaMetricsUtil.class).error(e.getMessage());
            }
        }
        return size;
    }

    public static void reportBulkSubscription(ObjectValue consumerObject, Set<String> topicsList) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        for (String topic : topicsList) {
            KafkaMetricsUtil.reportSubscription(consumerObject, topic);
        }
    }

    public static void reportSubscription(ObjectValue consumerObject, String topic) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        KafkaObserverContext observerContext = new KafkaObserverContext("consumer", KafkaUtils.getClientId(consumerObject), KafkaUtils.getBootstrapServers(consumerObject), topic);
        KafkaMetricsUtil.setGauge(observerContext, KafkaObservabilityConstants.METRIC_SUBSCRIPTION[0], KafkaObservabilityConstants.METRIC_SUBSCRIPTION[1], 1);
    }

    public static void reportUnsubscription(ObjectValue consumerObject, String topic) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        KafkaObserverContext observerContext = new KafkaObserverContext("consumer", KafkaUtils.getClientId(consumerObject), KafkaUtils.getBootstrapServers(consumerObject), topic);
        KafkaMetricsUtil.resetGauge(observerContext, KafkaObservabilityConstants.METRIC_SUBSCRIPTION[0], KafkaObservabilityConstants.METRIC_SUBSCRIPTION[1]);
    }

    public static void reportBulkUnsubscription(ObjectValue consumerObject, Set<String> topics) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        for (String subject : topics) {
            KafkaMetricsUtil.reportUnsubscription(consumerObject, subject);
        }
    }

    public static void reportConsume(ObjectValue consumerObject, String topic, Object value) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        KafkaObserverContext observerContext = new KafkaObserverContext("consumer", KafkaUtils.getClientId(consumerObject), KafkaUtils.getBootstrapServers(consumerObject), topic);
        int size = KafkaMetricsUtil.getMessageSize(value);
        KafkaMetricsUtil.reportConsume(observerContext, size);
    }

    public static void reportConsume(ObjectValue consumerObject, ConsumerRecords records) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        for (Object record : records) {
            KafkaMetricsUtil.reportConsume(consumerObject, ((ConsumerRecord)record).topic(), ((ConsumerRecord)record).serializedValueSize());
        }
    }

    public static void reportProducerError(ObjectValue producerObject, String errorType) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        KafkaMetricsUtil.reportError("producer", producerObject, errorType);
    }

    public static void reportConsumerError(String errorType) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        KafkaMetricsUtil.reportError("consumer", errorType);
    }

    public static void reportConsumerError(ObjectValue consumerObject, String errorType) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        KafkaMetricsUtil.reportError("consumer", consumerObject, errorType);
    }

    public static void reportConsumerError(ObjectValue consumerObject, String topic, String errorType) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        KafkaMetricsUtil.reportError(consumerObject, topic, "consumer", errorType);
    }

    private static void reportPublish(KafkaObserverContext observerContext, int size) {
        KafkaMetricsUtil.incrementCounter(observerContext, KafkaObservabilityConstants.METRIC_PUBLISHED[0], KafkaObservabilityConstants.METRIC_PUBLISHED[1]);
        KafkaMetricsUtil.incrementCounter(observerContext, KafkaObservabilityConstants.METRIC_PUBLISHED_SIZE[0], KafkaObservabilityConstants.METRIC_PUBLISHED_SIZE[1], size);
    }

    private static void reportConsume(KafkaObserverContext observerContext, int size) {
        KafkaMetricsUtil.incrementCounter(observerContext, KafkaObservabilityConstants.METRIC_CONSUMED[0], KafkaObservabilityConstants.METRIC_CONSUMED[1]);
        KafkaMetricsUtil.incrementCounter(observerContext, KafkaObservabilityConstants.METRIC_CONSUMED_SIZE[0], KafkaObservabilityConstants.METRIC_CONSUMED_SIZE[1], size);
    }

    public static void reportError(String context, String errorType) {
        KafkaObserverContext observerContext = new KafkaObserverContext(context);
        observerContext.addTag("error_type", errorType);
        KafkaMetricsUtil.incrementCounter(observerContext, KafkaObservabilityConstants.METRIC_ERRORS[0], KafkaObservabilityConstants.METRIC_ERRORS[1]);
    }

    public static void reportError(String context, ObjectValue object, String errorType) {
        KafkaObserverContext observerContext = new KafkaObserverContext(context, KafkaUtils.getClientId(object), KafkaUtils.getBootstrapServers(object));
        observerContext.addTag("error_type", errorType);
        KafkaMetricsUtil.incrementCounter(observerContext, KafkaObservabilityConstants.METRIC_ERRORS[0], KafkaObservabilityConstants.METRIC_ERRORS[1]);
    }

    public static void reportError(ObjectValue object, String topic, String context, String errorType) {
        KafkaObserverContext observerContext = new KafkaObserverContext(context, KafkaUtils.getClientId(object), KafkaUtils.getBootstrapServers(object), topic);
        observerContext.addTag("error_type", errorType);
        KafkaMetricsUtil.incrementCounter(observerContext, KafkaObservabilityConstants.METRIC_ERRORS[0], KafkaObservabilityConstants.METRIC_ERRORS[1]);
    }

    private static void incrementCounter(KafkaObserverContext observerContext, String name, String desc) {
        KafkaMetricsUtil.incrementCounter(observerContext, name, desc, 1);
    }

    private static void incrementCounter(KafkaObserverContext observerContext, String name, String desc, int amount) {
        if (metricRegistry == null) {
            return;
        }
        metricRegistry.counter(new MetricId("kafka_" + name, desc, observerContext.getAllTags())).increment((long)amount);
    }

    private static void incrementGauge(KafkaObserverContext observerContext, String name, String desc) {
        if (metricRegistry == null) {
            return;
        }
        metricRegistry.gauge(new MetricId("kafka_" + name, desc, observerContext.getAllTags()), new StatisticConfig[0]).increment();
    }

    private static void decrementGauge(KafkaObserverContext observerContext, String name, String desc) {
        if (metricRegistry == null) {
            return;
        }
        metricRegistry.gauge(new MetricId("kafka_" + name, desc, observerContext.getAllTags()), new StatisticConfig[0]).decrement();
    }

    private static void setGauge(KafkaObserverContext observerContext, String name, String desc, int value) {
        if (metricRegistry == null) {
            return;
        }
        metricRegistry.gauge(new MetricId("kafka_" + name, desc, observerContext.getAllTags()), new StatisticConfig[0]).setValue((double)value);
    }

    private static void resetGauge(KafkaObserverContext observerContext, String name, String desc) {
        if (metricRegistry == null) {
            return;
        }
        metricRegistry.gauge(new MetricId("kafka_" + name, desc, observerContext.getAllTags()), new StatisticConfig[0]).setValue(0.0);
    }

    private KafkaMetricsUtil() {
    }
}

