/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.service;

import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.messaging.kafka.exceptions.KafkaConnectorException;
import org.ballerinalang.messaging.kafka.impl.KafkaListenerImpl;
import org.ballerinalang.messaging.kafka.impl.KafkaServerConnectorImpl;
import org.ballerinalang.messaging.kafka.utils.KafkaUtils;

public class Register {
    public static Object register(ObjectValue listener, ObjectValue service, Object name) {
        Strand strand = Scheduler.getStrand();
        MapValue listenerConfigurations = listener.getMapValue("consumerConfig");
        Properties configs = KafkaUtils.processKafkaConsumerConfig((MapValue<String, Object>)listenerConfigurations);
        try {
            KafkaConsumer kafkaConsumer = null;
            if (Objects.nonNull(listener.getNativeData("KafkaConsumer"))) {
                kafkaConsumer = (KafkaConsumer)listener.getNativeData("KafkaConsumer");
            }
            KafkaListenerImpl kafkaListener = new KafkaListenerImpl(strand, listener, service);
            String serviceId = service.getType().getQualifiedName();
            KafkaServerConnectorImpl serverConnector = new KafkaServerConnectorImpl(serviceId, configs, kafkaListener, kafkaConsumer);
            listener.addNativeData("serverConnector", (Object)serverConnector);
        }
        catch (KafkaConnectorException e) {
            return KafkaUtils.createKafkaError(e.getMessage(), "{ballerina/kafka}ConsumerError");
        }
        return null;
    }
}

