/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.xml;

import javax.xml.namespace.QName;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.XMLItem;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.langlib.xml.IsElement;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.xml", functionName="setName", args={@Argument(name="xmlValue", type=TypeKind.XML), @Argument(name="newName", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.NIL)}, isPublic=true)
public class SetName {
    private static final String OPERATION = "set element name in xml";

    public static void setName(Strand strand, XMLValue xmlVal, String newName) {
        if (!IsElement.isElement(strand, xmlVal)) {
            throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.XML_FUNC_TYPE_ERROR, (Object[])new Object[]{"setName", "element"});
        }
        try {
            if (xmlVal.getNodeType() == XMLNodeType.ELEMENT) {
                QName newQName;
                if (newName.startsWith("{")) {
                    int endCurly = newName.indexOf(125);
                    String nsUri = newName.substring(0, endCurly);
                    String localPart = newName.substring(endCurly + 1, newName.length() - 1);
                    newQName = new QName(nsUri, localPart);
                } else {
                    newQName = new QName(newName);
                }
                ((XMLItem)xmlVal).setQName(newQName);
            }
        }
        catch (Throwable e) {
            BLangExceptionHelper.handleXMLException((String)OPERATION, (Throwable)e);
        }
    }
}

