/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.email.client;

import java.io.IOException;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.stdlib.email.util.SmtpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpClient {
    private static final Logger log = LoggerFactory.getLogger(SmtpClient.class);

    private SmtpClient() {
    }

    public static void initClientEndpoint(ObjectValue clientEndpoint, String host, final String username, final String password, MapValue<Object, Object> config) {
        Properties properties = SmtpUtil.getProperties(config, host);
        Session session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
        clientEndpoint.addNativeData("session", (Object)session);
        clientEndpoint.addNativeData("username", (Object)username);
    }

    public static Object sendMessage(ObjectValue clientConnector, MapValue<Object, Object> message) {
        try {
            Transport.send((Message)SmtpUtil.generateMessage((Session)clientConnector.getNativeData("session"), (String)clientConnector.getNativeData("username"), message));
            return null;
        }
        catch (IOException | MessagingException e) {
            log.error("Failed to send message to SMTP server : ", e);
            return BallerinaErrors.createError((BString)StringUtils.fromString((String)"{ballerina/email}SendError"), (String)e.getMessage());
        }
    }
}

