/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.email.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.HandleValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.mime.nativeimpl.EntityHeaders;
import org.ballerinalang.mime.nativeimpl.MimeDataSourceBuilder;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.stdlib.email.util.CommonUtil;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpUtil {
    private static final Logger log = LoggerFactory.getLogger(SmtpUtil.class);

    public static Properties getProperties(MapValue smtpConfig, String host) {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", host);
        properties.put("mail.smtp.port", Long.toString(smtpConfig.getIntValue("port")));
        properties.put("mail.smtp.auth", "true");
        properties.put("mail.smtp.starttls.enable", "true");
        properties.put("mail.smtp.ssl.enable", smtpConfig.getBooleanValue("enableSsl"));
        CommonUtil.addCustomProperties(smtpConfig.getMapValue("properties"), properties);
        if (log.isDebugEnabled()) {
            Set<String> propertySet = properties.stringPropertyNames();
            log.debug("SMTP Properties set are as follows.");
            for (String propertyObj : propertySet) {
                log.debug("Property Name: " + propertyObj + ", Value: " + properties.get(propertyObj).toString() + " ValueType: " + properties.get(propertyObj).getClass().getName());
            }
        }
        return properties;
    }

    public static MimeMessage generateMessage(Session session, String username, MapValue message) throws MessagingException, IOException {
        ArrayValue attachments;
        Address[] toAddressArray = SmtpUtil.extractAddressLists(message, "to");
        Address[] ccAddressArray = SmtpUtil.extractAddressLists(message, "cc");
        Address[] bccAddressArray = SmtpUtil.extractAddressLists(message, "bcc");
        Address[] replyToAddressArray = SmtpUtil.extractAddressLists(message, "replyTo");
        String subject = message.getStringValue("subject");
        String messageBody = message.getStringValue("body");
        String fromAddress = message.getStringValue("from");
        if (fromAddress == null || fromAddress.isEmpty()) {
            fromAddress = username;
        }
        String senderAddress = SmtpUtil.getNullCheckedString(message.getStringValue("sender"));
        MimeMessage emailMessage = new MimeMessage(session);
        emailMessage.setRecipients(Message.RecipientType.TO, toAddressArray);
        if (ccAddressArray.length > 0) {
            emailMessage.setRecipients(Message.RecipientType.CC, ccAddressArray);
        }
        if (bccAddressArray.length > 0) {
            emailMessage.setRecipients(Message.RecipientType.BCC, bccAddressArray);
        }
        if (replyToAddressArray.length > 0) {
            emailMessage.setReplyTo(replyToAddressArray);
        }
        emailMessage.setSubject(subject);
        emailMessage.setFrom((Address)new InternetAddress(fromAddress));
        if (!senderAddress.isEmpty()) {
            emailMessage.setSender((Address)new InternetAddress(senderAddress));
        }
        if ((attachments = message.getArrayValue("attachments")) == null) {
            emailMessage.setText(messageBody);
        } else {
            SmtpUtil.addBodyAndAttachments(emailMessage, messageBody, attachments);
        }
        return emailMessage;
    }

    private static void addBodyAndAttachments(MimeMessage emailMessage, String messageBody, ArrayValue attachments) throws MessagingException, IOException {
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(messageBody);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        for (int i = 0; i < attachments.size(); ++i) {
            if (!(attachments.get((long)i) instanceof ObjectValue)) continue;
            ObjectValue mimeEntity = (ObjectValue)attachments.get((long)i);
            String contentType = MimeUtil.getContentTypeWithParameters((ObjectValue)mimeEntity);
            if (contentType.startsWith("multipart/")) {
                multipart.addBodyPart((BodyPart)SmtpUtil.populateMultipart(mimeEntity));
                continue;
            }
            multipart.addBodyPart((BodyPart)SmtpUtil.buildJavaMailBodyPart(mimeEntity, contentType));
        }
        emailMessage.setContent((Multipart)multipart);
    }

    private static MimeBodyPart populateMultipart(ObjectValue mimeEntity) throws IOException, MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        ArrayValue multipartMimeEntityArrayValue = EntityBodyHandler.getBodyPartArray((ObjectValue)mimeEntity);
        int entityCount = multipartMimeEntityArrayValue.size();
        for (int i = 0; i < entityCount; ++i) {
            ObjectValue childMimeEntity = (ObjectValue)multipartMimeEntityArrayValue.get((long)i);
            String childContentType = MimeUtil.getContentTypeWithParameters((ObjectValue)childMimeEntity);
            if (childContentType.startsWith("multipart/")) {
                multipart.addBodyPart((BodyPart)SmtpUtil.populateMultipart(childMimeEntity));
                continue;
            }
            multipart.addBodyPart((BodyPart)SmtpUtil.buildJavaMailBodyPart(childMimeEntity, childContentType));
        }
        MimeBodyPart returnMimeBodyPart = new MimeBodyPart();
        returnMimeBodyPart.setContent((Multipart)multipart);
        return returnMimeBodyPart;
    }

    private static MimeBodyPart buildJavaMailBodyPart(ObjectValue mimeEntity, String contentType) throws MessagingException, IOException {
        MimeBodyPart attachmentBodyPart = new MimeBodyPart();
        Channel channel = EntityBodyHandler.getByteChannel((ObjectValue)mimeEntity);
        if (channel != null) {
            InputStream inputStream = channel.getInputStream();
            ByteArrayDataSource ds = new ByteArrayDataSource(inputStream, contentType);
            attachmentBodyPart.setDataHandler(new DataHandler((DataSource)ds));
        } else if (CommonUtil.isTextBased(contentType)) {
            attachmentBodyPart.setText((String)MimeDataSourceBuilder.getText((ObjectValue)mimeEntity));
        } else {
            ArrayValue binaryContent = (ArrayValue)MimeDataSourceBuilder.getByteArray((ObjectValue)mimeEntity);
            attachmentBodyPart.setContent((Object)binaryContent.getBytes(), "application/octet-stream");
        }
        SmtpUtil.addHeadersToJavaMailBodyPart(mimeEntity, attachmentBodyPart);
        return attachmentBodyPart;
    }

    private static void addHeadersToJavaMailBodyPart(ObjectValue mimeEntity, MimeBodyPart attachmentBodyPart) throws MessagingException {
        ArrayValue headerNamesArrayValue = EntityHeaders.getHeaderNames((ObjectValue)mimeEntity, (Object)"leading");
        HandleValue[] handleValues = (HandleValue[])headerNamesArrayValue.getValues();
        String[] headerNames = new String[handleValues.length];
        for (int j = 0; j < handleValues.length; ++j) {
            headerNames[j] = handleValues[j].stringValue();
        }
        if (headerNames.length > 0) {
            for (String headerName : headerNames) {
                String headerValue = EntityHeaders.getHeader((ObjectValue)mimeEntity, (String)headerName, (Object)"leading");
                if (!SmtpUtil.isNotEmpty(headerValue)) continue;
                log.debug("Added a MIME body part header " + headerName + " with value " + headerValue);
                attachmentBodyPart.setHeader(headerName, headerValue);
            }
        }
    }

    private static Address[] extractAddressLists(MapValue message, String addressType) throws AddressException {
        String[] address = SmtpUtil.getNullCheckedStringArray(message, addressType);
        int addressArrayLength = address.length;
        Address[] addressArray = new Address[addressArrayLength];
        for (int i = 0; i < addressArrayLength; ++i) {
            addressArray[i] = new InternetAddress(address[i]);
        }
        return addressArray;
    }

    private static String[] getNullCheckedStringArray(MapValue mapValue, String parameter) {
        ArrayValue arrayValue = mapValue.getArrayValue(parameter);
        if (arrayValue != null) {
            return arrayValue.getStringArray();
        }
        return new String[0];
    }

    private static String getNullCheckedString(String string) {
        return string == null ? "" : string;
    }

    private static boolean isNotEmpty(String string) {
        return string != null && !string.isEmpty();
    }
}

