/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.httpclient;

import java.util.Locale;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.net.http.DataContext;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.actions.httpclient.AbstractHTTPAction;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class Forward
extends AbstractHTTPAction {
    public static Object forward(ObjectValue httpClient, String path, ObjectValue requestObj) {
        String url = httpClient.getStringValue("url");
        Strand strand = Scheduler.getStrand();
        HttpCarbonMessage outboundRequestMsg = Forward.createOutboundRequestMsg(strand, url, path, requestObj);
        HttpClientConnector clientConnector = (HttpClientConnector)httpClient.getNativeData("Client");
        DataContext dataContext = new DataContext(strand, clientConnector, new NonBlockingCallback(strand), requestObj, outboundRequestMsg);
        Forward.executeNonBlockingAction(dataContext, false);
        return null;
    }

    protected static HttpCarbonMessage createOutboundRequestMsg(Strand strand, String serviceUri, String path, ObjectValue requestObj) {
        if (requestObj.getNativeData("Request") == null && !HttpUtil.isEntityDataSourceAvailable(requestObj)) {
            throw new BallerinaException("invalid inbound request parameter");
        }
        HttpCarbonMessage outboundRequestMsg = HttpUtil.getCarbonMsg(requestObj, HttpUtil.createHttpCarbonMessage(true));
        if (HttpUtil.isEntityDataSourceAvailable(requestObj)) {
            HttpUtil.enrichOutboundMessage(outboundRequestMsg, requestObj);
            Forward.prepareOutboundRequest(strand, serviceUri, path, outboundRequestMsg, HttpUtil.checkRequestBodySizeHeadersAvailability(outboundRequestMsg) == false);
            outboundRequestMsg.setHttpMethod(requestObj.get("method").toString());
        } else {
            Forward.prepareOutboundRequest(strand, serviceUri, path, outboundRequestMsg, HttpUtil.checkRequestBodySizeHeadersAvailability(outboundRequestMsg) == false);
            String httpVerb = outboundRequestMsg.getHttpMethod();
            outboundRequestMsg.setHttpMethod(httpVerb.trim().toUpperCase(Locale.getDefault()));
        }
        return outboundRequestMsg;
    }
}

