/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.websocketconnector;

import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.websocket.WebSocketException;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.observability.WebSocketObservabilityUtil;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ready {
    private static final Logger log = LoggerFactory.getLogger(Ready.class);

    public static Object ready(ObjectValue wsConnector) {
        WebSocketConnectionInfo connectionInfo = (WebSocketConnectionInfo)wsConnector.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO");
        WebSocketObservabilityUtil.observeResourceInvocation(Scheduler.getStrand(), connectionInfo, "ready");
        try {
            boolean isReady = wsConnector.getBooleanValue("isReady");
            if (isReady) {
                return new WebSocketException("Already started reading frames");
            }
            WebSocketUtil.readFirstFrame(connectionInfo.getWebSocketConnection(), wsConnector);
            connectionInfo.getWebSocketEndpoint().getMapValue("config").put((Object)"readyOnConnect", (Object)true);
        }
        catch (Exception e) {
            log.error("Error occurred when calling ready", (Throwable)e);
            WebSocketObservabilityUtil.observeError(connectionInfo, "ready", e.getMessage());
            return WebSocketUtil.createErrorByType(e);
        }
        return null;
    }

    private Ready() {
    }
}

