/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.clientendpoint;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.HttpConnectionManager;
import org.ballerinalang.net.http.HttpErrorType;
import org.ballerinalang.net.http.HttpUtil;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.config.SenderConfiguration;
import org.wso2.transport.http.netty.contract.config.TransportsConfiguration;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.ConnectionManager;
import org.wso2.transport.http.netty.message.HttpConnectorUtil;

public class CreateSimpleHttpClient {
    public static void createSimpleHttpClient(ObjectValue httpClient, MapValue<String, Long> globalPoolConfig) {
        URL url;
        String urlString = httpClient.getStringValue("url").replaceAll("(?<!(http:|https:))//", "/");
        httpClient.set("url", (Object)urlString);
        MapValue clientEndpointConfig = (MapValue)httpClient.get("config");
        HttpConnectionManager connectionManager = HttpConnectionManager.getInstance();
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw HttpUtil.createHttpError("malformed URL: " + urlString, HttpErrorType.GENERIC_CLIENT_ERROR);
        }
        String scheme = url.getProtocol();
        Map properties = HttpConnectorUtil.getTransportProperties((TransportsConfiguration)connectionManager.getTransportConfig());
        SenderConfiguration senderConfiguration = new SenderConfiguration();
        senderConfiguration.setScheme(scheme);
        if (connectionManager.isHTTPTraceLoggerEnabled()) {
            senderConfiguration.setHttpTraceLogEnabled(true);
        }
        senderConfiguration.setTLSStoreType("PKCS12");
        String httpVersion = clientEndpointConfig.getStringValue("httpVersion");
        if ("2.0".equals(httpVersion)) {
            MapValue http2Settings = (MapValue)clientEndpointConfig.get((Object)"http2Settings");
            boolean http2PriorKnowledge = (Boolean)http2Settings.get((Object)"http2PriorKnowledge");
            senderConfiguration.setForceHttp2(http2PriorKnowledge);
        } else {
            MapValue http1Settings = (MapValue)clientEndpointConfig.get((Object)"http1Settings");
            String chunking = http1Settings.getStringValue("chunking");
            senderConfiguration.setChunkingConfig(HttpUtil.getChunkConfig(chunking));
            String keepAliveConfig = http1Settings.getStringValue("keepAlive");
            senderConfiguration.setKeepAliveConfig(HttpUtil.getKeepAliveConfig(keepAliveConfig));
        }
        MapValue responseLimits = (MapValue)clientEndpointConfig.get((Object)"responseLimits");
        HttpUtil.setInboundMgsSizeValidationConfig(responseLimits.getIntValue("maxStatusLineLength"), responseLimits.getIntValue("maxHeaderSize"), responseLimits.getIntValue("maxEntityBodySize"), senderConfiguration.getMsgSizeValidationConfig());
        try {
            HttpUtil.populateSenderConfigurations(senderConfiguration, (MapValue<String, Object>)clientEndpointConfig, scheme);
        }
        catch (RuntimeException e) {
            throw HttpUtil.createHttpError(e.getMessage(), HttpErrorType.GENERIC_CLIENT_ERROR);
        }
        MapValue userDefinedPoolConfig = (MapValue)clientEndpointConfig.get((Object)"poolConfig");
        ConnectionManager poolManager = userDefinedPoolConfig == null ? HttpUtil.getConnectionManager(globalPoolConfig) : HttpUtil.getConnectionManager((MapValue<String, Long>)userDefinedPoolConfig);
        try {
            HttpClientConnector httpClientConnector = HttpUtil.createHttpWsConnectionFactory().createHttpsClientConnector(properties, senderConfiguration, poolManager);
            httpClient.addNativeData("Client", (Object)httpClientConnector);
        }
        catch (Exception e) {
            throw HttpUtil.createHttpError(e.getMessage(), HttpErrorType.GENERIC_CLIENT_ERROR);
        }
    }
}

