/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.nativeimpl;

import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.net.http.HttpErrorType;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.uri.URIUtil;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class ExternRequest {
    private static final BMapType mapType = new BMapType((BType)new BArrayType(BTypes.typeString));

    public static ObjectValue createNewEntity(ObjectValue requestObj) {
        return HttpUtil.createNewEntity(requestObj);
    }

    public static void setEntity(ObjectValue requestObj, ObjectValue entityObj) {
        HttpUtil.setEntity(requestObj, entityObj, true);
    }

    public static MapValue<String, Object> getQueryParams(ObjectValue requestObj) {
        try {
            Object queryParams = requestObj.getNativeData("queryParamMap");
            if (queryParams != null) {
                return (MapValue)queryParams;
            }
            HttpCarbonMessage httpCarbonMessage = (HttpCarbonMessage)requestObj.getNativeData("transport_message");
            MapValueImpl params = new MapValueImpl((BType)mapType);
            Object rawQueryString = httpCarbonMessage.getProperty("RAW_QUERY_STR");
            if (rawQueryString != null) {
                URIUtil.populateQueryParamMap((String)rawQueryString, (MapValue<String, Object>)params);
            }
            requestObj.addNativeData("queryParamMap", (Object)params);
            return params;
        }
        catch (Exception e) {
            throw HttpUtil.createHttpError("error while retrieving query param from message: " + e.getMessage(), HttpErrorType.GENERIC_LISTENER_ERROR);
        }
    }

    public static MapValue<String, Object> getMatrixParams(ObjectValue requestObj, String path) {
        HttpCarbonMessage httpCarbonMessage = HttpUtil.getCarbonMsg(requestObj, null);
        return URIUtil.getMatrixParamsMap(path, httpCarbonMessage);
    }

    public static Object getEntity(ObjectValue requestObj) {
        return HttpUtil.getEntity(requestObj, true, true);
    }

    public static ObjectValue getEntityWithoutBody(ObjectValue requestObj) {
        return HttpUtil.getEntity(requestObj, true, false);
    }

    public static boolean checkEntityBodyAvailability(ObjectValue requestObj) {
        ObjectValue entityObj = (ObjectValue)requestObj.get("entity");
        return ExternRequest.lengthHeaderCheck(requestObj) || EntityBodyHandler.checkEntityBodyAvailability((ObjectValue)entityObj);
    }

    private static boolean lengthHeaderCheck(ObjectValue requestObj) {
        Object outboundMsg = requestObj.getNativeData("transport_message");
        if (outboundMsg == null) {
            return false;
        }
        return HttpUtil.checkRequestBodySizeHeadersAvailability((HttpCarbonMessage)outboundMsg);
    }
}

