/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.nativeimpl;

import java.util.Arrays;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.net.http.HttpErrorType;
import org.ballerinalang.net.http.HttpUtil;

public class ParseHeader {
    private static final BTupleType parseHeaderTupleType = new BTupleType(Arrays.asList(BTypes.typeString, BTypes.typeMap));

    public static Object parseHeader(String headerValue) {
        if (headerValue == null) {
            return HttpUtil.createHttpError(HttpErrorType.GENERIC_CLIENT_ERROR.getReason(), HttpErrorType.GENERIC_CLIENT_ERROR.getErrorName(), "{ballerina/mime}ReadingHeaderFailed", "failed to parse: header value cannot be null");
        }
        try {
            if (headerValue.contains(",")) {
                headerValue = headerValue.substring(0, headerValue.indexOf(","));
            }
            String value = headerValue.trim();
            if (headerValue.contains(";")) {
                value = HeaderUtil.getHeaderValue((String)value);
            }
            BArray contentTuple = BValueCreator.createTupleValue((BTupleType)parseHeaderTupleType);
            contentTuple.add(0L, (Object)value);
            contentTuple.add(1L, (Object)HeaderUtil.getParamMap((String)headerValue));
            return contentTuple;
        }
        catch (Exception ex) {
            String errMsg = ex instanceof ErrorValue ? "failed to parse: " + ex.toString() : "failed to parse: " + ex.getMessage();
            return HttpUtil.createHttpError(HttpErrorType.GENERIC_CLIENT_ERROR.getReason(), HttpErrorType.GENERIC_CLIENT_ERROR.getErrorName(), "{ballerina/mime}ReadingHeaderFailed", errMsg);
        }
    }
}

