/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.nativeimpl.pipelining;

import io.netty.channel.ChannelHandlerContext;
import java.util.Queue;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.nativeimpl.connection.ResponseWriter;
import org.ballerinalang.net.http.nativeimpl.pipelining.PipelineResponseListener;
import org.ballerinalang.net.http.nativeimpl.pipelining.PipelinedResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.Constants;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.contractimpl.HttpPipeliningListener;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpPipeliningFuture;

public class PipeliningHandler {
    private static final Logger log = LoggerFactory.getLogger(PipeliningHandler.class);

    public static HttpResponseFuture sendPipelinedResponse(HttpCarbonMessage requestMsg, HttpCarbonMessage responseMsg) {
        HttpResponseFuture responseFuture;
        try {
            responseMsg.setPipeliningEnabled(requestMsg.isPipeliningEnabled());
            if (PipeliningHandler.pipeliningRequired(requestMsg)) {
                PipelinedResponse pipelinedResponse = new PipelinedResponse(requestMsg, responseMsg);
                PipeliningHandler.setPipeliningListener(responseMsg);
                responseFuture = PipeliningHandler.executePipeliningLogic(requestMsg.getSourceContext(), pipelinedResponse);
            } else {
                responseFuture = requestMsg.respond(responseMsg);
            }
        }
        catch (ServerConnectorException e) {
            throw new BallerinaConnectorException("Error occurred while sending outbound response", (Throwable)e);
        }
        return responseFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponseFuture executePipeliningLogic(ChannelHandlerContext sourceContext, PipelinedResponse pipelinedResponse) {
        HttpResponseFuture responseFuture = null;
        Queue queue = (Queue)sourceContext.channel().attr(Constants.RESPONSE_QUEUE).get();
        synchronized (queue) {
            Queue responseQueue = (Queue)sourceContext.channel().attr(Constants.RESPONSE_QUEUE).get();
            if (PipeliningHandler.thresholdReached(sourceContext, responseQueue)) {
                return null;
            }
            if (pipelinedResponse != null) {
                responseQueue.add(pipelinedResponse);
            }
            while (!responseQueue.isEmpty()) {
                long nextSequenceNumber = (Long)sourceContext.channel().attr(Constants.NEXT_SEQUENCE_NUMBER).get();
                PipelinedResponse queuedPipelinedResponse = (PipelinedResponse)responseQueue.peek();
                long currentSequenceNumber = queuedPipelinedResponse.getSequenceId();
                if (currentSequenceNumber != nextSequenceNumber) break;
                responseQueue.remove();
                if (queuedPipelinedResponse.getDataContext() != null && queuedPipelinedResponse.getOutboundResponseObj() != null) {
                    ResponseWriter.sendResponseRobust(queuedPipelinedResponse.getDataContext(), queuedPipelinedResponse.getInboundRequestMsg(), queuedPipelinedResponse.getOutboundResponseObj(), queuedPipelinedResponse.getOutboundResponseMsg());
                    continue;
                }
                responseFuture = HttpUtil.sendOutboundResponse(queuedPipelinedResponse.getInboundRequestMsg(), queuedPipelinedResponse.getOutboundResponseMsg());
            }
            return responseFuture;
        }
    }

    public static boolean pipeliningRequired(HttpCarbonMessage request) {
        String httpVersion = request.getHttpVersion();
        return request.isPipeliningEnabled() && request.isKeepAlive() && "1.1".equalsIgnoreCase(httpVersion);
    }

    private static boolean thresholdReached(ChannelHandlerContext sourceContext, Queue<PipelinedResponse> responseQueue) {
        long maxQueuedResponses = (Long)sourceContext.channel().attr(Constants.MAX_RESPONSES_ALLOWED_TO_BE_QUEUED).get();
        if (-1L == maxQueuedResponses) {
            return false;
        }
        if ((long)responseQueue.size() > maxQueuedResponses) {
            sourceContext.channel().close();
            log.warn("Threshold {} for pipelined response queue reached hence closing the connection.", (Object)maxQueuedResponses);
            return true;
        }
        return false;
    }

    public static void setPipeliningListener(HttpCarbonMessage httpResponse) {
        PipelineResponseListener pipeliningListener = new PipelineResponseListener();
        HttpPipeliningFuture pipeliningFuture = new HttpPipeliningFuture();
        pipeliningFuture.setPipeliningListener((HttpPipeliningListener)pipeliningListener);
        httpResponse.setPipeliningFuture(pipeliningFuture);
    }
}

