/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket;

import org.ballerinalang.jvm.services.ErrorHandlerUtils;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.observability.WebSocketObservabilityUtil;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;

public class WebSocketResourceCallback
implements CallableUnitCallback {
    private final WebSocketConnection webSocketConnection;
    private final WebSocketConnectionInfo connectionInfo;
    private final String resource;

    WebSocketResourceCallback(WebSocketConnectionInfo webSocketConnectionInfo, String resource) throws IllegalAccessException {
        this.connectionInfo = webSocketConnectionInfo;
        this.webSocketConnection = this.connectionInfo.getWebSocketConnection();
        this.resource = resource;
    }

    public void notifySuccess() {
        this.webSocketConnection.readNextFrame();
    }

    public void notifyFailure(ErrorValue error) {
        ErrorHandlerUtils.printError((String)error.getPrintableStackTrace());
        WebSocketUtil.closeDuringUnexpectedCondition(this.webSocketConnection);
        WebSocketObservabilityUtil.observeError(this.connectionInfo, "resource_invocation", this.resource, error.getMessage());
    }
}

