/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.client;

import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.client.InitEndpoint;
import org.ballerinalang.net.http.websocket.client.RetryContext;
import org.ballerinalang.net.http.websocket.client.listener.ClientConnectorListener;
import org.ballerinalang.net.http.websocket.client.listener.RetryConnectorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryInitEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(RetryInitEndpoint.class);
    private static final String INTERVAL_IN_MILLIS = "intervalInMillis";
    private static final String MAX_WAIT_INTERVAL = "maxWaitIntervalInMillis";
    private static final String MAX_COUNT = "maxCount";
    private static final String BACK_OF_FACTOR = "backOffFactor";

    public static void initEndpoint(ObjectValue retryClient) {
        MapValue clientEndpointConfig = retryClient.getMapValue("config");
        MapValue retryConfig = clientEndpointConfig.getMapValue("retryConfig");
        RetryContext retryConnectorConfig = new RetryContext();
        RetryInitEndpoint.populateRetryConnectorConfig((MapValue<String, Object>)retryConfig, retryConnectorConfig);
        retryClient.addNativeData("retryConfig", (Object)retryConnectorConfig);
        retryClient.addNativeData("clientListener", (Object)new RetryConnectorListener(new ClientConnectorListener()));
        InitEndpoint.initEndpoint(retryClient);
    }

    private static void populateRetryConnectorConfig(MapValue<String, Object> retryConfig, RetryContext retryConnectorConfig) {
        retryConnectorConfig.setInterval(WebSocketUtil.getIntValue(retryConfig, INTERVAL_IN_MILLIS, 1000));
        retryConnectorConfig.setBackOfFactor(RetryInitEndpoint.getDoubleValue(retryConfig));
        retryConnectorConfig.setMaxInterval(WebSocketUtil.getIntValue(retryConfig, MAX_WAIT_INTERVAL, 30000));
        retryConnectorConfig.setMaxAttempts(WebSocketUtil.getIntValue(retryConfig, MAX_COUNT, 0));
    }

    private static Double getDoubleValue(MapValue<String, Object> configs) {
        double value = Math.toRadians(configs.getFloatValue(BACK_OF_FACTOR));
        if (value < 1.0) {
            logger.warn("The value set for `backOffFactor` needs to be great than than 1. The `backOffFactor` value is set to {}", (Object)1.0);
            value = 1.0;
        }
        return value;
    }

    private RetryInitEndpoint() {
    }
}

