/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.client.listener;

import java.io.IOException;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.client.listener.ExtendedConnectorListener;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.WebSocketBinaryMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketCloseMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketHandshaker;
import org.wso2.transport.http.netty.contract.websocket.WebSocketTextMessage;

public class RetryConnectorListener
implements ExtendedConnectorListener {
    private WebSocketConnectionInfo connectionInfo = null;
    private static final Logger logger = LoggerFactory.getLogger(RetryConnectorListener.class);
    private ExtendedConnectorListener connectorListener;
    public static final String LOG_MESSAGE = "{} {}";

    public RetryConnectorListener(ExtendedConnectorListener connectorListener) {
        this.connectorListener = connectorListener;
    }

    @Override
    public void setConnectionInfo(WebSocketConnectionInfo connectionInfo) {
        this.connectorListener.setConnectionInfo(connectionInfo);
        this.connectionInfo = connectionInfo;
    }

    public void onHandshake(WebSocketHandshaker webSocketHandshaker) {
        this.connectorListener.onHandshake(webSocketHandshaker);
    }

    public void onMessage(WebSocketTextMessage textMessage) {
        this.connectorListener.onMessage(textMessage);
    }

    public void onMessage(WebSocketBinaryMessage binaryMessage) {
        this.connectorListener.onMessage(binaryMessage);
    }

    public void onMessage(WebSocketControlMessage controlMessage) {
        this.connectorListener.onMessage(controlMessage);
    }

    public void onMessage(WebSocketCloseMessage webSocketCloseMessage) {
        ObjectValue webSocketClient = this.connectionInfo.getWebSocketEndpoint();
        int statusCode = webSocketCloseMessage.getCloseCode();
        if (WebSocketUtil.hasRetryContext(webSocketClient)) {
            if (statusCode == 1006 && WebSocketUtil.reconnect(webSocketClient, this.connectionInfo.getService())) {
                return;
            }
            if (statusCode != 1006 && logger.isDebugEnabled()) {
                logger.debug(LOG_MESSAGE, (Object)"Reconnect attempt not made because of close initiated by the server: ", (Object)webSocketClient.getStringValue("url"));
            }
        }
        this.connectorListener.onMessage(webSocketCloseMessage);
    }

    public void onClose(WebSocketConnection webSocketConnection) {
        this.connectorListener.onClose(webSocketConnection);
    }

    public void onError(WebSocketConnection webSocketConnection, Throwable throwable) {
        ObjectValue webSocketClient = this.connectionInfo.getWebSocketEndpoint();
        if (WebSocketUtil.hasRetryContext(webSocketClient) && throwable instanceof IOException && WebSocketUtil.reconnect(webSocketClient, this.connectionInfo.getService())) {
            return;
        }
        this.connectorListener.onError(webSocketConnection, throwable);
    }

    public void onIdleTimeout(WebSocketControlMessage controlMessage) {
        this.connectorListener.onIdleTimeout(controlMessage);
    }
}

