/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.ballerina.openapi.convertor.service;

import io.swagger.models.ModelImpl;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.parser.SwaggerParser;
import io.swagger.parser.util.SwaggerDeserializationResult;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.converter.SwaggerConverter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.ballerina.openapi.convertor.OpenApiConverterException;
import org.ballerinalang.ballerina.openapi.convertor.service.OpenApiEndpointMapper;
import org.ballerinalang.ballerina.openapi.convertor.service.OpenApiServiceMapper;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.langserver.compiler.ExtendedLSCompiler;
import org.ballerinalang.langserver.compiler.common.modal.BallerinaFile;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.types.TypeNode;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;

public class OpenApiConverterUtils {
    private static final PrintStream outStream = System.err;

    public static String generateOpenApiDefinitions(String ballerinaSource, String serviceName) throws IOException {
        try {
            BallerinaFile ballerinaFile = ExtendedLSCompiler.compileContent((String)ballerinaSource, (CompilerPhase)CompilerPhase.DEFINE);
            BLangCompilationUnit topCompilationUnit = ballerinaFile.getBLangPackage().map(bLangPackage -> (BLangCompilationUnit)bLangPackage.getCompilationUnits().get(0)).orElse(null);
            if (topCompilationUnit == null) {
                return "Error";
            }
            String httpAlias = OpenApiConverterUtils.getAlias(topCompilationUnit, "ballerina/http");
            String openApiAlias = OpenApiConverterUtils.getAlias(topCompilationUnit, "ballerina/openapi");
            OpenApiServiceMapper openApiServiceMapper = new OpenApiServiceMapper(httpAlias, openApiAlias);
            ArrayList<BLangSimpleVariable> endpoints = new ArrayList<BLangSimpleVariable>();
            Swagger openapi = OpenApiConverterUtils.getOpenApiDefinition(new Swagger(), openApiServiceMapper, serviceName, topCompilationUnit, endpoints);
            return openApiServiceMapper.generateOpenApiString(openapi);
        }
        catch (CompilationFailedException e) {
            return "Error";
        }
    }

    public static String generateOAS3Definitions(String ballerinaSource, String serviceName) throws OpenApiConverterException {
        try {
            BallerinaFile ballerinaFile = ExtendedLSCompiler.compileContent((String)ballerinaSource, (CompilerPhase)CompilerPhase.DEFINE);
            BLangCompilationUnit topCompilationUnit = ballerinaFile.getBLangPackage().map(bLangPackage -> (BLangCompilationUnit)bLangPackage.getCompilationUnits().get(0)).orElse(null);
            if (topCompilationUnit == null) {
                return "Error";
            }
            TopLevelNode serviceNode = topCompilationUnit.getTopLevelNodes().stream().filter(topLevelNode -> topLevelNode instanceof BLangService).findAny().orElse(null);
            if (serviceNode == null) {
                return "Error";
            }
            List annotationAttachments = ((BLangService)serviceNode).getAnnotationAttachments();
            Iterator annoIterator = annotationAttachments.iterator();
            String openApiContractPath = "";
            BLangAnnotationAttachment isServiceAnnotationAvailable = annotationAttachments.stream().filter(bLangAnnotationAttachment -> bLangAnnotationAttachment.getAnnotationName().getValue().equals("ServiceInfo")).findAny().orElse(null);
            if (annoIterator.hasNext() && isServiceAnnotationAvailable != null) {
                while (annoIterator.hasNext()) {
                    BLangAnnotationAttachment annotation = (BLangAnnotationAttachment)annoIterator.next();
                    if (!annotation.getAnnotationName().getValue().equals("ServiceInfo")) continue;
                    BLangRecordLiteral expression = (BLangRecordLiteral)annotation.getExpression();
                    for (BLangRecordLiteral.BLangRecordKeyValueField keyValuePair : expression.getFields()) {
                        BLangExpression key = keyValuePair.getKey();
                        if (!(key instanceof BLangSimpleVarRef)) continue;
                        BLangSimpleVarRef varRef = (BLangSimpleVarRef)key;
                        if (!"contract".equals(varRef.variableName.value)) continue;
                        openApiContractPath = ((BLangLiteral)keyValuePair.getValue()).value.toString();
                    }
                }
                OpenAPI api = new OpenAPIV3Parser().read(openApiContractPath);
                if (api == null) {
                    throw new OpenApiConverterException("Please check if input source is valid and complete");
                }
                return Yaml.pretty((Object)api);
            }
            String httpAlias = OpenApiConverterUtils.getAlias(topCompilationUnit, "ballerina/http");
            String openApiAlias = OpenApiConverterUtils.getAlias(topCompilationUnit, "ballerina/openapi");
            OpenApiServiceMapper openApiServiceMapper = new OpenApiServiceMapper(httpAlias, openApiAlias);
            ArrayList<BLangSimpleVariable> endpoints = new ArrayList<BLangSimpleVariable>();
            Swagger openapi = OpenApiConverterUtils.getOpenApiDefinition(new Swagger(), openApiServiceMapper, serviceName, topCompilationUnit, endpoints);
            String openApiSource = openApiServiceMapper.generateOpenApiString(openapi);
            SwaggerConverter converter = new SwaggerConverter();
            SwaggerDeserializationResult result = new SwaggerParser().readWithInfo(openApiSource);
            if (result.getMessages().size() > 0) {
                throw new OpenApiConverterException("Please check the mentioned service is available in the ballerina source, or thee content is valid");
            }
            return Yaml.pretty((Object)converter.convert(result).getOpenAPI());
        }
        catch (CompilationFailedException e) {
            return "Error";
        }
    }

    private static Swagger getOpenApiDefinition(Swagger openapi, OpenApiServiceMapper openApiServiceMapper, String serviceName, BLangCompilationUnit topCompilationUnit, List<BLangSimpleVariable> endpoints) {
        HashMap<String, ModelImpl> definitions = new HashMap<String, ModelImpl>();
        for (TopLevelNode topLevelNode : topCompilationUnit.getTopLevelNodes()) {
            if (topLevelNode instanceof BLangSimpleVariable && ((BLangSimpleVariable)topLevelNode).getFlags().contains(Flag.LISTENER)) {
                endpoints.add((BLangSimpleVariable)topLevelNode);
            }
            if (topLevelNode instanceof BLangService && openapi.getBasePath() == null) {
                BLangService serviceDefinition = (BLangService)topLevelNode;
                openapi = new OpenApiEndpointMapper().convertBoundEndpointsToOpenApi(endpoints, (ServiceNode)serviceDefinition, openapi);
                if (StringUtils.isNotBlank((CharSequence)serviceName)) {
                    if (serviceDefinition.getName().getValue().equals(serviceName)) {
                        openapi = openApiServiceMapper.convertServiceToOpenApi(serviceDefinition, openapi);
                    }
                } else {
                    openapi = openApiServiceMapper.convertServiceToOpenApi(serviceDefinition, openapi);
                }
            }
            if (!(topLevelNode instanceof BLangTypeDefinition)) continue;
            BLangTypeDefinition typeNode = (BLangTypeDefinition)topLevelNode;
            if (!(typeNode.typeNode instanceof BLangRecordTypeNode)) continue;
            ModelImpl model = new ModelImpl();
            List fields = ((BLangRecordTypeNode)typeNode.typeNode).getFields();
            HashMap<String, Property> propertyMap = new HashMap<String, Property>();
            for (SimpleVariableNode field : fields) {
                Property openApiPropertyForBallerinaField = OpenApiConverterUtils.createOpenApiPropertyForBallerinaField(field.getTypeNode());
                if (openApiPropertyForBallerinaField == null) continue;
                propertyMap.put(field.getName().getValue(), openApiPropertyForBallerinaField);
            }
            model.setProperties(propertyMap);
            definitions.put(typeNode.getName().getValue(), model);
            openapi.setDefinitions(definitions);
        }
        return openapi;
    }

    public static Property createOpenApiPropertyForBallerinaField(TypeNode node) {
        Property property = null;
        if (node instanceof BLangArrayType) {
            BLangArrayType fieldTypeNode = (BLangArrayType)node;
            ArrayProperty arr = new ArrayProperty();
            arr.setItems(OpenApiConverterUtils.mapBallerinaTypes(fieldTypeNode.getElementType().type.getKind().typeName(), true));
            property = arr;
        } else if (node instanceof BLangBuiltInRefTypeNode) {
            BLangBuiltInRefTypeNode fieldTypeNode = (BLangBuiltInRefTypeNode)node;
            property = OpenApiConverterUtils.mapBallerinaTypes(fieldTypeNode.typeKind.typeName(), false);
        } else if (!(node instanceof BLangConstrainedType)) {
            if (node instanceof BLangErrorType) {
                BLangErrorType fieldTypeNode = (BLangErrorType)node;
                BType bErrorType = fieldTypeNode.type;
                if (bErrorType instanceof BErrorType) {
                    property = OpenApiConverterUtils.mapBallerinaTypes(((BErrorType)bErrorType).getReasonType().getKind().typeName(), false);
                }
            } else if (!(node instanceof BLangFiniteTypeNode || node instanceof BLangFunctionTypeNode || node instanceof BLangObjectTypeNode || node instanceof BLangRecordTypeNode || node instanceof BLangStructureTypeNode || node instanceof BLangTupleTypeNode || node instanceof BLangUnionTypeNode)) {
                if (node instanceof BLangUserDefinedType) {
                    BLangUserDefinedType fieldTypeNode = (BLangUserDefinedType)node;
                    property = OpenApiConverterUtils.mapBallerinaTypes(fieldTypeNode.getTypeName().value, false);
                } else if (node instanceof BLangValueType) {
                    BLangValueType fieldTypeNode = (BLangValueType)node;
                    property = OpenApiConverterUtils.mapBallerinaTypes(fieldTypeNode.getTypeKind().typeName(), false);
                }
            }
        }
        return property;
    }

    public static Property mapBallerinaTypes(String type, boolean isArray) {
        switch (type) {
            case "any": {
                return null;
            }
            case "int": {
                return new IntegerProperty();
            }
            case "string": {
                return new StringProperty();
            }
            case "boolean": {
                return new BooleanProperty();
            }
            case "decimal": {
                return new DecimalProperty();
            }
            case "byte": {
                return new ByteArrayProperty();
            }
            case "float": {
                return new FloatProperty();
            }
            case "json": {
                return new ObjectProperty();
            }
        }
        return null;
    }

    public static void generateOAS3Definitions(Path servicePath, Path outPath, String serviceName) throws IOException, OpenApiConverterException {
        String balSource = OpenApiConverterUtils.readFromFile(servicePath);
        String openApiName = OpenApiConverterUtils.getOpenApiFileName(servicePath, serviceName);
        String openApiSource = OpenApiConverterUtils.generateOAS3Definitions(balSource, serviceName);
        OpenApiConverterUtils.writeFile(outPath.resolve(openApiName), openApiSource);
    }

    public static void generateOAS3DefinitionFromModule(String moduleName, String serviceName, Path output) throws OpenApiConverterException {
        BLangPackage pkg;
        try {
            pkg = OpenApiConverterUtils.compileModule(Paths.get(System.getProperty("user.dir"), new String[0]), moduleName);
        }
        catch (Exception e) {
            throw new OpenApiConverterException(e.getLocalizedMessage());
        }
        if (pkg == null) {
            throw new OpenApiConverterException("The provided Ballerina module is not valid. Please provide a valid module.");
        }
        BLangService service = pkg.services.stream().filter(bLangService -> serviceName.equals(bLangService.getName().getValue())).findAny().orElse(null);
        if (service == null) {
            throw new OpenApiConverterException("Couldn't find " + serviceName + " service in the provided module. Please check that there is a service in the module.");
        }
        BLangCompilationUnit topCompilationUnit = pkg.getCompilationUnits().stream().filter(bLangCompilationUnit -> bLangCompilationUnit.getName().equals(service.pos.src.cUnitName)).findAny().orElse(null);
        if (topCompilationUnit == null) {
            throw new OpenApiConverterException("Please check if input source is valid and complete.");
        }
        String httpAlias = OpenApiConverterUtils.getAlias(topCompilationUnit, "ballerina/http");
        String openApiAlias = OpenApiConverterUtils.getAlias(topCompilationUnit, "ballerina/openapi");
        OpenApiServiceMapper openApiServiceMapper = new OpenApiServiceMapper(httpAlias, openApiAlias);
        ArrayList<BLangSimpleVariable> endpoints = new ArrayList<BLangSimpleVariable>();
        Swagger openapi = OpenApiConverterUtils.getOpenApiDefinition(new Swagger(), openApiServiceMapper, serviceName, topCompilationUnit, endpoints);
        String openApiSource = openApiServiceMapper.generateOpenApiString(openapi);
        SwaggerConverter converter = new SwaggerConverter();
        SwaggerDeserializationResult result = new SwaggerParser().readWithInfo(openApiSource);
        if (result.getMessages().size() > 0) {
            throw new OpenApiConverterException("Please check if input source is valid and complete");
        }
        if (OpenApiConverterUtils.checkOASFileExists(serviceName + ".yaml", output)) {
            throw new OpenApiConverterException("The output location already contains an OpenApi Contract named " + serviceName + ".yaml");
        }
        String openApiResource = Yaml.pretty((Object)converter.convert(result).getOpenAPI());
        try {
            OpenApiConverterUtils.writeFile(output.resolve(serviceName + ".yaml"), openApiResource);
            outStream.println("The OpenApi Contract was successfully generated at " + output.toRealPath(new LinkOption[0]));
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)e.getLocalizedMessage());
        }
    }

    public static void generateOpenApiDefinitions(Path servicePath, Path outPath, String serviceName) throws IOException {
        String balSource = OpenApiConverterUtils.readFromFile(servicePath);
        String openApiName = OpenApiConverterUtils.getOpenApiFileName(servicePath, serviceName);
        String openApiSource = OpenApiConverterUtils.generateOpenApiDefinitions(balSource, serviceName);
        OpenApiConverterUtils.writeFile(outPath.resolve(openApiName), openApiSource);
    }

    private static boolean checkOASFileExists(String fileName, Path exportLocation) {
        return Files.exists(exportLocation.resolve(fileName), new LinkOption[0]);
    }

    private static String readFromFile(Path servicePath) throws IOException {
        String source = FileUtils.readFileToString((File)servicePath.toFile(), (String)"UTF-8");
        return source;
    }

    private static void writeFile(Path path, String content) throws IOException {
        Path parentPath = path.getParent();
        if (null != parentPath && Files.exists(parentPath, new LinkOption[0])) {
            Files.createDirectories(parentPath, new FileAttribute[0]);
        }
        Files.deleteIfExists(path);
        Files.createFile(path, new FileAttribute[0]);
        try (PrintWriter writer = new PrintWriter(path.toString(), "UTF-8");){
            writer.print(content);
            outStream.println("Successfully generated the ballerina contract at location \n" + path.toAbsolutePath());
        }
    }

    private static String getOpenApiFileName(Path servicePath, String serviceName) {
        Path file = servicePath.getFileName();
        String openApiFile = StringUtils.isNotBlank((CharSequence)serviceName) ? serviceName + ".openapi" : (file != null ? FilenameUtils.removeExtension((String)file.toString()) + ".openapi" : null);
        return openApiFile + ".yaml";
    }

    private static String getAlias(BLangCompilationUnit topCompilationUnit, String packageName) {
        for (TopLevelNode topLevelNode : topCompilationUnit.getTopLevelNodes()) {
            if (!(topLevelNode instanceof BLangImportPackage)) continue;
            BLangImportPackage importPackage = (BLangImportPackage)topLevelNode;
            String packagePath = importPackage.getPackageName().stream().map(BLangIdentifier::getValue).collect(Collectors.joining("."));
            packagePath = importPackage.getOrgName().toString() + '/' + packagePath;
            if (!packageName.equals(packagePath)) continue;
            return importPackage.getAlias().getValue();
        }
        return null;
    }

    private static BLangPackage compileModule(Path sourceRoot, String moduleName) {
        CompilerContext context = OpenApiConverterUtils.getCompilerContext(sourceRoot);
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        try {
            compiler.setOutStream((PrintStream)new EmptyPrintStream());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return compiler.compile(moduleName);
    }

    private static CompilerContext getCompilerContext(Path sourceRootPath) {
        CompilerPhase compilerPhase = CompilerPhase.DEFINE;
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRootPath.toString());
        options.put(CompilerOptionName.OFFLINE, Boolean.toString(false));
        options.put(CompilerOptionName.COMPILER_PHASE, compilerPhase.toString());
        options.put(CompilerOptionName.SKIP_TESTS, Boolean.toString(false));
        options.put(CompilerOptionName.TEST_ENABLED, "true");
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(true));
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, Boolean.toString(true));
        return context;
    }

    static class EmptyPrintStream
    extends PrintStream {
        EmptyPrintStream() throws UnsupportedEncodingException {
            super(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }, true, "UTF-8");
        }
    }
}

