/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.ballerina.openapi.convertor.service;

import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.ballerina.openapi.convertor.ConverterUtils;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.expressions.SimpleVariableReferenceNode;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;

public class OpenApiEndpointMapper {
    public Swagger convertBoundEndpointsToOpenApi(List<BLangSimpleVariable> endpoints, ServiceNode service, Swagger openapi) {
        if (endpoints == null || service == null || service.getAttachedExprs().isEmpty() || ((ExpressionNode)service.getAttachedExprs().get(0)).getKind() != NodeKind.SIMPLE_VARIABLE_REF && ((ExpressionNode)service.getAttachedExprs().get(0)).getKind() != NodeKind.TYPE_INIT_EXPR) {
            return openapi;
        }
        if (openapi == null) {
            return new Swagger();
        }
        if (((ExpressionNode)service.getAttachedExprs().get(0)).getKind() == NodeKind.TYPE_INIT_EXPR) {
            BLangTypeInit type = (BLangTypeInit)service.getAttachedExprs().get(0);
            List list = type.argsExpr;
            ArrayList<Scheme> schemes = new ArrayList<Scheme>();
            String port = null;
            String host = null;
            if (list.size() == 1) {
                port = ConverterUtils.getStringLiteralValue((BLangExpression)list.get(0));
            }
            if (list.size() > 1 && list.get(1) instanceof BLangNamedArgsExpression && ((BLangNamedArgsExpression)list.get(1)).getExpression() instanceof BLangRecordLiteral) {
                BLangRecordLiteral bLangRecordLiteral = (BLangRecordLiteral)((BLangNamedArgsExpression)list.get(1)).getExpression();
                Map<String, BLangExpression> configs = ConverterUtils.listToMap(bLangRecordLiteral.fields);
                host = configs.get("host") != null ? ConverterUtils.getStringLiteralValue(configs.get("host")) : null;
                Scheme scheme = configs.get("secureSocket") == null ? Scheme.HTTP : Scheme.HTTPS;
                schemes.add(scheme);
            }
            if (host == null) {
                host = "localhost";
            }
            if (port != null) {
                host = host + ':' + port;
            }
            openapi.setHost(host);
            openapi.setSchemes(schemes);
        } else if (((ExpressionNode)service.getAttachedExprs().get(0)).getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            SimpleVariableReferenceNode node = (SimpleVariableReferenceNode)service.getAttachedExprs().get(0);
            for (BLangSimpleVariable ep : endpoints) {
                if (!node.getVariableName().equals(ep.getName())) continue;
                this.extractServer(ep, openapi);
                break;
            }
        }
        return openapi;
    }

    private void extractServer(BLangSimpleVariable ep, Swagger openapi) {
        BLangTypeInit bTypeInit = (BLangTypeInit)ep.getInitialExpression();
        List list = bTypeInit.argsExpr;
        ArrayList<Scheme> schemes = new ArrayList<Scheme>();
        String port = null;
        String host = null;
        if (list.size() == 1) {
            port = ConverterUtils.getStringLiteralValue((BLangExpression)list.get(0));
        }
        if (list.size() > 1 && list.get(1) instanceof BLangNamedArgsExpression && ((BLangNamedArgsExpression)list.get(1)).getExpression() instanceof BLangRecordLiteral) {
            BLangRecordLiteral bLangRecordLiteral = (BLangRecordLiteral)((BLangNamedArgsExpression)list.get(1)).getExpression();
            Map<String, BLangExpression> configs = ConverterUtils.listToMap(bLangRecordLiteral.fields);
            host = configs.get("host") != null ? ConverterUtils.getStringLiteralValue(configs.get("host")) : null;
            Scheme scheme = configs.get("secureSocket") == null ? Scheme.HTTP : Scheme.HTTPS;
            schemes.add(scheme);
        }
        if (host == null) {
            host = "localhost";
        }
        if (port != null) {
            host = host + ':' + port;
        }
        openapi.setHost(host);
        openapi.setSchemes(schemes);
    }
}

