/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.ballerina.openapi.convertor.service;

import com.google.common.collect.Lists;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ballerinalang.ballerina.openapi.convertor.ConverterUtils;
import org.ballerinalang.ballerina.openapi.convertor.service.OperationAdaptor;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;

public class OpenApiResourceMapper {
    private final String httpAlias;
    private final String openApiAlias;
    private final Swagger openApiDefinition;

    OpenApiResourceMapper(Swagger openApi, String httpAlias, String openApiAlias) {
        this.httpAlias = httpAlias;
        this.openApiAlias = openApiAlias;
        this.openApiDefinition = openApi;
    }

    protected Map<String, Path> convertResourceToPath(List<BLangFunction> resources) {
        HashMap<String, Path> pathMap = new HashMap<String, Path>();
        for (BLangFunction resource : resources) {
            List<String> methods = this.getHttpMethods(resource, false);
            if (methods.size() == 0 || methods.size() > 1) {
                this.useMultiResourceMapper(pathMap, resource);
                continue;
            }
            this.useDefaultResourceMapper(pathMap, resource);
        }
        return pathMap;
    }

    private void useMultiResourceMapper(Map<String, Path> pathMap, BLangFunction resource) {
        List<String> httpMethods = this.getHttpMethods(resource, false);
        String path = this.getPath(resource);
        Path pathObject = new Path();
        if (httpMethods.size() > 1) {
            int i = 1;
            for (String httpMethod : httpMethods) {
                Operation operation = this.convertResourceToOperation(resource, httpMethod, i).getOperation();
                pathObject.set(httpMethod.toLowerCase(Locale.ENGLISH), operation);
                ++i;
            }
        }
        pathMap.put(path, pathObject);
    }

    private void useDefaultResourceMapper(Map<String, Path> pathMap, BLangFunction resource) {
        String httpMethod = this.getHttpMethods(resource, true).get(0);
        OperationAdaptor operationAdaptor = this.convertResourceToOperation(resource, httpMethod, 1);
        operationAdaptor.setHttpOperation(httpMethod);
        Path path = pathMap.get(operationAdaptor.getPath());
        if (path == null) {
            path = new Path();
            pathMap.put(operationAdaptor.getPath(), path);
        }
        Operation operation = operationAdaptor.getOperation();
        switch (httpMethod) {
            case "GET": {
                path.get(operation);
                break;
            }
            case "PUT": {
                path.put(operation);
                break;
            }
            case "POST": {
                path.post(operation);
                break;
            }
            case "DELETE": {
                path.delete(operation);
                break;
            }
            case "OPTIONS": {
                path.options(operation);
                break;
            }
            case "PATCH": {
                path.patch(operation);
                break;
            }
            case "HEAD": {
                path.head(operation);
                break;
            }
        }
    }

    private OperationAdaptor convertResourceToOperation(BLangFunction resource, String httpMethod, int idIncrement) {
        OperationAdaptor op = new OperationAdaptor();
        if (resource != null) {
            op.setHttpOperation(httpMethod);
            op.setPath('/' + resource.getName().getValue());
            Response response = new Response().description("Successful").example("application/json", (Object)"Ok");
            op.getOperation().response(200, response);
            String resName = resource.getName().getValue().replaceAll("_", " ");
            op.getOperation().setOperationId(this.getOperationId(idIncrement, resName));
            op.getOperation().setParameters(null);
            this.parseResourceConfigAnnotationAttachment(resource, op);
            this.parseResourceInfo(resource, op.getOperation(), httpMethod);
            this.addResourceParameters(resource, op);
            this.parseResponsesAnnotationAttachment(resource, op.getOperation());
        }
        return op;
    }

    private String getOperationId(int idIncrement, String postFix) {
        return "operation" + idIncrement + "_" + postFix;
    }

    private void parseResponsesAnnotationAttachment(BLangFunction resource, Operation op) {
        BLangListConstructorExpr valueArr;
        BLangRecordLiteral bLiteral;
        Map<String, BLangExpression> attrs;
        AnnotationAttachmentNode annotation = ConverterUtils.getAnnotationFromList("Responses", this.openApiAlias, resource.getAnnotationAttachments());
        if (annotation != null && (attrs = ConverterUtils.listToMap((bLiteral = (BLangRecordLiteral)((BLangAnnotationAttachment)annotation).getExpression()).getFields())).containsKey("value") && (valueArr = (BLangListConstructorExpr)attrs.get("value")).getExpressions().size() > 0) {
            HashMap<String, Response> responses = new HashMap<String, Response>();
            for (ExpressionNode expr : valueArr.getExpressions()) {
                Map<String, BLangExpression> attributes = ConverterUtils.listToMap(((BLangRecordLiteral)expr).getFields());
                if (!attributes.containsKey("code")) continue;
                String code = ConverterUtils.getStringLiteralValue(attributes.get("code"));
                Response response = new Response();
                if (attributes.containsKey("description")) {
                    response.setDescription(ConverterUtils.getStringLiteralValue(attributes.get("description")));
                }
                this.createHeadersModel(attributes.get("headers"), response);
                responses.put(code, response);
            }
            op.setResponses(responses);
        }
    }

    private void createHeadersModel(BLangExpression annotationExpression, Response response) {
        if (null != annotationExpression) {
            BLangListConstructorExpr headerArray = (BLangListConstructorExpr)annotationExpression;
            for (ExpressionNode headersValue : headerArray.getExpressions()) {
                Map<String, BLangExpression> headersAttributes = ConverterUtils.listToMap(((BLangRecordLiteral)headersValue).getFields());
                HashMap<String, Property> headers = new HashMap<String, Property>();
                if (headersAttributes.containsKey("name") && headersAttributes.containsKey("headerType")) {
                    String headerName = ConverterUtils.getStringLiteralValue(headersAttributes.get("name"));
                    String type = ConverterUtils.getStringLiteralValue(headersAttributes.get("headerType"));
                    Property property = this.getOpenApiProperty(type);
                    if (headersAttributes.containsKey("description")) {
                        property.setDescription(ConverterUtils.getStringLiteralValue(headersAttributes.get("description")));
                    }
                    headers.put(headerName, property);
                }
                response.setHeaders(headers);
            }
        }
    }

    private void addResourceParameters(BLangFunction resource, OperationAdaptor operationAdaptor) {
        AnnotationAttachmentNode annotation = ConverterUtils.getAnnotationFromList("ResourceConfig", this.httpAlias, resource.getAnnotationAttachments());
        if (annotation != null) {
            Map<String, BLangExpression> recordsMap = ConverterUtils.listToMap(((BLangRecordLiteral)((BLangAnnotationAttachment)annotation).getExpression()).getFields());
            if (recordsMap.containsKey("path") && recordsMap.get("path") != null) {
                String path = recordsMap.get("path").toString().trim();
                operationAdaptor.setPath(path);
            } else {
                operationAdaptor.setPath("/");
            }
        }
        if (resource.requiredParams.size() > 0) {
            List requiredParams = resource.requiredParams;
            for (Object parameter : requiredParams) {
                boolean isRequest;
                BLangSimpleVariable param = (BLangSimpleVariable)parameter;
                boolean isCaller = param.typeNode instanceof BLangUserDefinedType && ((BLangUserDefinedType)param.typeNode).typeName.value.equals("Caller");
                boolean bl = isRequest = param.typeNode instanceof BLangUserDefinedType && ((BLangUserDefinedType)param.typeNode).typeName.value.equals("Request");
                if (isCaller || isRequest) continue;
                PathParameter pathParameter = new PathParameter();
                pathParameter.setName(param.getName().value);
                pathParameter.setType(param.type.tsymbol.name.value);
                operationAdaptor.getOperation().addParameter((Parameter)pathParameter);
            }
        }
        if (!"get".equalsIgnoreCase(operationAdaptor.getHttpOperation())) {
            ModelImpl messageModel = new ModelImpl();
            messageModel.setType("object");
            HashMap<String, ModelImpl> definitions = new HashMap<String, ModelImpl>();
            if (!definitions.containsKey("Request")) {
                definitions.put("Request", messageModel);
                this.openApiDefinition.setDefinitions(definitions);
            }
            BodyParameter messageParameter = new BodyParameter();
            messageParameter.setName(((BLangSimpleVariable)resource.getParameters().get(0)).getName().getValue());
            RefModel refModel = new RefModel();
            refModel.setReference("Request");
            messageParameter.setSchema((Model)refModel);
            if (!operationAdaptor.getHttpOperation().equalsIgnoreCase("delete")) {
                operationAdaptor.getOperation().addParameter((Parameter)messageParameter);
            }
        }
    }

    private void createParametersModel(BLangExpression annotationExpression, Operation operation) {
        if (annotationExpression != null) {
            LinkedList<Parameter> parameters = new LinkedList<Parameter>();
            List paramExprs = ((BLangListConstructorExpr)annotationExpression).getExpressions();
            for (ExpressionNode expr : paramExprs) {
                Map<String, BLangExpression> paramAttributes = ConverterUtils.listToMap(((BLangRecordLiteral)expr).getFields());
                String in = paramAttributes.containsKey("inInfo") ? ConverterUtils.getStringLiteralValue(paramAttributes.get("inInfo")) : "path";
                Parameter param = this.buildParameter(in, paramAttributes);
                if (paramAttributes.containsKey("name")) {
                    param.setName(ConverterUtils.getStringLiteralValue(paramAttributes.get("name")));
                }
                if (paramAttributes.containsKey("description")) {
                    param.setDescription(ConverterUtils.getStringLiteralValue(paramAttributes.get("description")));
                }
                if (paramAttributes.containsKey("required")) {
                    param.setRequired(Boolean.parseBoolean(ConverterUtils.getStringLiteralValue(paramAttributes.get("required"))));
                }
                parameters.add(param);
            }
            operation.setParameters(parameters);
        }
    }

    private void parseResourceInfo(BLangFunction resource, Operation operation, String httpMethod) {
        AnnotationAttachmentNode multiResourceInfoAnnotation = ConverterUtils.getAnnotationFromList("MultiResourceInfo", this.openApiAlias, resource.getAnnotationAttachments());
        if (multiResourceInfoAnnotation != null) {
            this.parseMultiResourceInfoAnnotationAttachment(multiResourceInfoAnnotation, operation, httpMethod);
        } else {
            AnnotationAttachmentNode annotation = ConverterUtils.getAnnotationFromList("ResourceInfo", this.openApiAlias, resource.getAnnotationAttachments());
            if (annotation != null) {
                BLangRecordLiteral bLiteral = (BLangRecordLiteral)((BLangAnnotationAttachment)annotation).getExpression();
                this.addResourceInfoToOperation(bLiteral, operation);
            }
        }
    }

    private void parseMultiResourceInfoAnnotationAttachment(AnnotationAttachmentNode multiResourceInfoAnnotation, Operation operation, String httpMethod) {
        if (multiResourceInfoAnnotation != null) {
            BLangRecordLiteral.BLangRecordKeyValueField resourceInformationAttr;
            BLangRecordLiteral bLiteral = (BLangRecordLiteral)((BLangAnnotationAttachment)multiResourceInfoAnnotation).getExpression();
            BLangRecordLiteral.BLangRecordKeyValueField bLangRecordKeyValueField = resourceInformationAttr = bLiteral.fields.size() == 1 ? (BLangRecordLiteral.BLangRecordKeyValueField)bLiteral.fields.get(0) : null;
            if (resourceInformationAttr != null) {
                for (RecordLiteralNode.RecordField resourceInfo : ((BLangRecordLiteral)resourceInformationAttr.valueExpr).getFields()) {
                    BLangRecordLiteral.BLangRecordKeyValueField resourceInfoKeyValue = (BLangRecordLiteral.BLangRecordKeyValueField)resourceInfo;
                    if (!((BLangLiteral)resourceInfoKeyValue.key.expr).value.equals(httpMethod)) continue;
                    this.addResourceInfoToOperation((BLangRecordLiteral)resourceInfoKeyValue.valueExpr, operation);
                }
            }
        }
    }

    private void addResourceInfoToOperation(BLangRecordLiteral bLiteral, Operation operation) {
        Map<String, BLangExpression> attributes = ConverterUtils.listToMap(bLiteral.getFields());
        this.createTagModel(attributes.get("tags"), operation);
        if (attributes.containsKey("summary")) {
            operation.setSummary(ConverterUtils.getStringLiteralValue(attributes.get("summary")));
        }
        if (attributes.containsKey("description")) {
            operation.setDescription(ConverterUtils.getStringLiteralValue(attributes.get("description")));
        }
        if (attributes.containsKey("parameters")) {
            this.createParametersModel(attributes.get("parameters"), operation);
        }
        this.createExternalDocsModel(attributes.get("externalDoc"), operation);
    }

    private void createExternalDocsModel(BLangExpression annotationExpression, Operation operation) {
        if (null != annotationExpression && annotationExpression instanceof BLangRecordLiteral) {
            BLangRecordLiteral docAnnotation = (BLangRecordLiteral)annotationExpression;
            Map<String, BLangExpression> docAttrs = ConverterUtils.listToMap(docAnnotation.getFields());
            ExternalDocs externalDocs = new ExternalDocs();
            if (docAttrs.containsKey("description")) {
                externalDocs.setDescription(ConverterUtils.getStringLiteralValue(docAttrs.get("description")));
            }
            if (docAttrs.containsKey("url")) {
                externalDocs.setUrl(ConverterUtils.getStringLiteralValue(docAttrs.get("url")));
            }
            operation.setExternalDocs(externalDocs);
        }
    }

    private void createTagModel(BLangExpression annotationExpression, Operation operation) {
        if (null != annotationExpression) {
            List tagExprs = ((BLangListConstructorExpr)annotationExpression).getExpressions();
            LinkedList<String> tags = new LinkedList<String>();
            for (ExpressionNode expr : tagExprs) {
                if (!(expr instanceof BLangLiteral)) continue;
                BLangLiteral tagLit = (BLangLiteral)expr;
                tags.add(ConverterUtils.getStringLiteralValue((BLangExpression)tagLit));
            }
            operation.setTags(tags);
        }
    }

    private void parseResourceConfigAnnotationAttachment(BLangFunction resource, OperationAdaptor operation) {
        AnnotationAttachmentNode annotation = ConverterUtils.getAnnotationFromList("ResourceConfig", this.httpAlias, resource.getAnnotationAttachments());
        if (annotation != null) {
            BLangRecordLiteral bLiteral = (BLangRecordLiteral)((BLangAnnotationAttachment)annotation).getExpression();
            Map<String, BLangExpression> attributes = ConverterUtils.listToMap(bLiteral.getFields());
            if (attributes.containsKey("path")) {
                operation.setPath(ConverterUtils.getStringLiteralValue(attributes.get("path")));
            }
            if (attributes.containsKey("consumes")) {
                LinkedList<String> consumes = new LinkedList<String>();
                BLangListConstructorExpr consumesArray = (BLangListConstructorExpr)attributes.get("consumes");
                for (ExpressionNode expr : consumesArray.getExpressions()) {
                    BLangLiteral consumesLit;
                    String consumesVal;
                    if (!(expr instanceof BLangLiteral) || (consumesVal = ConverterUtils.getStringLiteralValue((BLangExpression)(consumesLit = (BLangLiteral)expr))) == null) continue;
                    consumes.add(consumesVal);
                }
                operation.getOperation().setConsumes(consumes);
            }
            if (attributes.containsKey("produces")) {
                LinkedList<String> produces = new LinkedList<String>();
                BLangListConstructorExpr producesArray = (BLangListConstructorExpr)attributes.get("produces");
                for (ExpressionNode expr : producesArray.getExpressions()) {
                    BLangLiteral producesLit;
                    String producesVal;
                    if (!(expr instanceof BLangLiteral) || (producesVal = ConverterUtils.getStringLiteralValue((BLangExpression)(producesLit = (BLangLiteral)expr))) == null) continue;
                    produces.add(producesVal);
                }
                operation.getOperation().setProduces(produces);
            }
        } else {
            operation.setPath(resource.getName().getValue());
        }
    }

    private List<String> getHttpMethods(BLangFunction resource, boolean useDefaults) {
        BLangRecordLiteral bLiteral;
        Map<String, BLangExpression> recordsMap;
        AnnotationAttachmentNode annotation = ConverterUtils.getAnnotationFromList("ResourceConfig", this.httpAlias, resource.getAnnotationAttachments());
        LinkedHashSet<String> httpMethods = new LinkedHashSet<String>();
        if (annotation != null && (recordsMap = ConverterUtils.listToMap((bLiteral = (BLangRecordLiteral)((BLangAnnotationAttachment)annotation).getExpression()).getFields())).containsKey("methods") && recordsMap.get("methods") != null) {
            List methodsValue = ((BLangListConstructorExpr)recordsMap.get("methods")).getExpressions();
            for (ExpressionNode expr : methodsValue) {
                httpMethods.add(ConverterUtils.getStringLiteralValue((BLangExpression)((BLangLiteral)expr)));
            }
        }
        if (httpMethods.isEmpty() && useDefaults) {
            httpMethods.add("GET");
            httpMethods.add("PUT");
            httpMethods.add("POST");
            httpMethods.add("DELETE");
            httpMethods.add("PATCH");
            httpMethods.add("OPTIONS");
            httpMethods.add("HEAD");
        }
        return Lists.reverse(new ArrayList(httpMethods));
    }

    private String getPath(BLangFunction resource) {
        BLangRecordLiteral bLiteral;
        Map<String, BLangExpression> attributes;
        String path = "/" + resource.getName();
        AnnotationAttachmentNode annotation = ConverterUtils.getAnnotationFromList("ResourceConfig", this.httpAlias, resource.getAnnotationAttachments());
        if (annotation != null && (attributes = ConverterUtils.listToMap((bLiteral = (BLangRecordLiteral)((BLangAnnotationAttachment)annotation).getExpression()).getFields())).containsKey("path")) {
            path = ConverterUtils.getStringLiteralValue(attributes.get("path"));
        }
        return path;
    }

    private Parameter buildParameter(String in, Map<String, BLangExpression> paramAttributes) {
        HeaderParameter param;
        switch (in) {
            case "body": {
                BodyParameter bParam = new BodyParameter();
                RefModel m = new RefModel();
                m.set$ref(ConverterUtils.getStringLiteralValue(paramAttributes.get("paramType")));
                bParam.setSchema((Model)m);
                param = bParam;
                break;
            }
            case "query": {
                String type;
                String attrType;
                QueryParameter qParam = new QueryParameter();
                switch (attrType = ConverterUtils.getStringLiteralValue(paramAttributes.get("paramType")).trim()) {
                    case "int": {
                        type = "integer";
                        break;
                    }
                    case "float": {
                        type = "number";
                        break;
                    }
                    default: {
                        type = attrType;
                    }
                }
                qParam.setType(type);
                param = qParam;
                break;
            }
            case "header": {
                param = new HeaderParameter();
                break;
            }
            case "cookie": {
                param = new CookieParameter();
                break;
            }
            case "form": {
                param = new FormParameter();
                break;
            }
            default: {
                PathParameter pParam = new PathParameter();
                pParam.setType(ConverterUtils.getStringLiteralValue(paramAttributes.get("paramType")));
                param = pParam;
            }
        }
        return param;
    }

    private Property getOpenApiProperty(String type) {
        StringProperty property;
        switch (type) {
            case "string": {
                property = new StringProperty();
                break;
            }
            case "boolean": {
                property = new BooleanProperty();
                break;
            }
            case "array": {
                property = new ArrayProperty();
                break;
            }
            case "number": 
            case "integer": {
                property = new IntegerProperty();
                break;
            }
            default: {
                property = new ObjectProperty();
            }
        }
        return property;
    }
}

