/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.ballerina.openapi.convertor.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.swagger.models.Contact;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.util.Json;
import java.util.LinkedList;
import java.util.Map;
import org.ballerinalang.ballerina.openapi.convertor.ConverterUtils;
import org.ballerinalang.ballerina.openapi.convertor.service.OpenApiResourceMapper;
import org.ballerinalang.ballerina.openapi.convertor.service.model.Organization;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class OpenApiServiceMapper {
    private static final Logger logger = LoggerFactory.getLogger(OpenApiServiceMapper.class);
    private String httpAlias;
    private String openApiAlias;
    private ObjectMapper objectMapper;

    public OpenApiServiceMapper(String httpAlias, String openApiAlias) {
        this.httpAlias = httpAlias;
        this.openApiAlias = openApiAlias;
        this.objectMapper = Json.mapper();
    }

    public String generateOpenApiString(Swagger openapi) {
        try {
            return this.objectMapper.writeValueAsString((Object)openapi);
        }
        catch (JsonProcessingException e) {
            logger.error("Error while generating openApi string from definition" + (Object)((Object)e));
            return "Error";
        }
    }

    public Swagger convertServiceToOpenApi(BLangService service) {
        Swagger openapi = new Swagger();
        return this.convertServiceToOpenApi(service, openapi);
    }

    public Swagger convertServiceToOpenApi(BLangService service, Swagger openapi) {
        openapi.setBasePath('/' + service.getName().getValue());
        this.parseServiceInfoAnnotationAttachment((ServiceNode)service, openapi);
        this.parseConfigAnnotationAttachment((ServiceNode)service, openapi);
        OpenApiResourceMapper resourceMapper = new OpenApiResourceMapper(openapi, this.httpAlias, this.openApiAlias);
        openapi.setPaths(resourceMapper.convertResourceToPath(service.getResources()));
        return openapi;
    }

    private void parseServiceInfoAnnotationAttachment(ServiceNode service, Swagger openapi) {
        AnnotationAttachmentNode annotation = ConverterUtils.getAnnotationFromList("ServiceInfo", this.openApiAlias, service.getAnnotationAttachments());
        Info info = new Info().version("1.0.0").title(service.getName().getValue());
        if (annotation != null) {
            BLangRecordLiteral bLiteral = (BLangRecordLiteral)((BLangAnnotationAttachment)annotation).getExpression();
            Map<String, BLangExpression> attributes = ConverterUtils.listToMap(bLiteral.getFields());
            if (attributes.containsKey("serviceVersion")) {
                info.version(ConverterUtils.getStringLiteralValue(attributes.get("serviceVersion")));
            }
            if (attributes.containsKey("title")) {
                info.title(ConverterUtils.getStringLiteralValue(attributes.get("title")));
            }
            if (attributes.containsKey("description")) {
                info.description(ConverterUtils.getStringLiteralValue(attributes.get("description")));
            }
            if (attributes.containsKey("termsOfService")) {
                info.termsOfService(ConverterUtils.getStringLiteralValue(attributes.get("termsOfService")));
            }
            this.createContactModel(attributes.get("contact"), info);
            this.createLicenseModel(attributes.get("license"), info);
            this.createExternalDocModel(attributes.get("externalDoc"), openapi);
            this.createTagModel(attributes.get("tags"), openapi);
            this.createOrganizationModel(attributes.get("organization"), info);
        }
        openapi.setInfo(info);
    }

    private void createOrganizationModel(BLangExpression annotationExpression, Info info) {
        if (null != annotationExpression) {
            BLangRecordLiteral orgAnnotation = (BLangRecordLiteral)annotationExpression;
            Map<String, BLangExpression> organizationAttributes = ConverterUtils.listToMap(orgAnnotation.getFields());
            Organization organization = new Organization();
            if (organizationAttributes.containsKey("name")) {
                organization.setName(ConverterUtils.getStringLiteralValue(organizationAttributes.get("name")));
            }
            if (organizationAttributes.containsKey("url")) {
                organization.setUrl(ConverterUtils.getStringLiteralValue(organizationAttributes.get("url")));
            }
            info.setVendorExtension("x-organization", (Object)organization);
        }
    }

    private void createTagModel(BLangExpression annotationExpression, Swagger openApi) {
        if (null != annotationExpression) {
            LinkedList<Tag> tags = new LinkedList<Tag>();
            BLangListConstructorExpr tagArray = (BLangListConstructorExpr)annotationExpression;
            for (ExpressionNode expr : tagArray.getExpressions()) {
                Map<String, BLangExpression> tagAttributes = ConverterUtils.listToMap(((BLangRecordLiteral)expr).getFields());
                Tag tag = new Tag();
                if (tagAttributes.containsKey("name")) {
                    tag.setName(ConverterUtils.getStringLiteralValue(tagAttributes.get("name")));
                }
                if (tagAttributes.containsKey("description")) {
                    tag.setDescription(ConverterUtils.getStringLiteralValue(tagAttributes.get("description")));
                }
                tags.add(tag);
            }
            openApi.setTags(Lists.reverse(tags));
        }
    }

    private void createExternalDocModel(BLangExpression annotationExpression, Swagger openApi) {
        if (null != annotationExpression) {
            BLangRecordLiteral docAnnotation = (BLangRecordLiteral)annotationExpression;
            Map<String, BLangExpression> externalDocAttributes = ConverterUtils.listToMap(docAnnotation.getFields());
            ExternalDocs externalDocs = new ExternalDocs();
            if (externalDocAttributes.containsKey("description")) {
                externalDocs.setDescription(ConverterUtils.getStringLiteralValue(externalDocAttributes.get("description")));
            }
            if (externalDocAttributes.containsKey("url")) {
                externalDocs.setUrl(ConverterUtils.getStringLiteralValue(externalDocAttributes.get("url")));
            }
            openApi.setExternalDocs(externalDocs);
        }
    }

    private void createContactModel(BLangExpression annotationExpression, Info info) {
        if (null != annotationExpression) {
            BLangRecordLiteral contactAnnotation = (BLangRecordLiteral)annotationExpression;
            Map<String, BLangExpression> contactAttributes = ConverterUtils.listToMap(contactAnnotation.getFields());
            Contact contact = new Contact();
            if (contactAttributes.containsKey("name")) {
                contact.setName(ConverterUtils.getStringLiteralValue(contactAttributes.get("name")));
            }
            if (contactAttributes.containsKey("email")) {
                contact.setEmail(ConverterUtils.getStringLiteralValue(contactAttributes.get("email")));
            }
            if (contactAttributes.containsKey("url")) {
                contact.setUrl(ConverterUtils.getStringLiteralValue(contactAttributes.get("url")));
            }
            info.setContact(contact);
        }
    }

    private void createLicenseModel(BLangExpression annotationExpression, Info info) {
        if (null != annotationExpression) {
            BLangRecordLiteral licenseAnnotation = (BLangRecordLiteral)annotationExpression;
            Map<String, BLangExpression> licenseAttributes = ConverterUtils.listToMap(licenseAnnotation.getFields());
            License license = new License();
            if (licenseAttributes.containsKey("name")) {
                license.setName(ConverterUtils.getStringLiteralValue(licenseAttributes.get("name")));
            }
            if (licenseAttributes.containsKey("url")) {
                license.setUrl(ConverterUtils.getStringLiteralValue(licenseAttributes.get("url")));
            }
            info.setLicense(license);
        }
    }

    private void parseConfigAnnotationAttachment(ServiceNode service, Swagger openApi) {
        BLangRecordLiteral bLiteral;
        Map<String, BLangExpression> attributes;
        AnnotationAttachmentNode annotation = ConverterUtils.getAnnotationFromList("ServiceConfig", this.httpAlias, service.getAnnotationAttachments());
        if (annotation != null && (attributes = ConverterUtils.listToMap((bLiteral = (BLangRecordLiteral)((BLangAnnotationAttachment)annotation).getExpression()).getFields())).containsKey("basePath")) {
            openApi.setBasePath(ConverterUtils.getStringLiteralValue(attributes.get("basePath")));
        }
    }
}

