/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.channel.unix;

import io.grpc.netty.shaded.io.netty.channel.unix.GenericUnixChannelOption;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.nio.ByteBuffer;

public final class RawUnixChannelOption
extends GenericUnixChannelOption<ByteBuffer> {
    private final int length;

    public RawUnixChannelOption(String name, int level, int optname, int length) {
        super(name, level, optname);
        this.length = ObjectUtil.checkPositive(length, "length");
    }

    public int length() {
        return this.length;
    }

    @Override
    public void validate(ByteBuffer value2) {
        super.validate(value2);
        if (value2.remaining() != this.length) {
            throw new IllegalArgumentException("Length of value does not match. Expected " + this.length + ", but got " + value2.remaining());
        }
    }
}

