/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal;

import io.jaegertracing.internal.JaegerSpanContext;
import io.jaegertracing.internal.JaegerTracer;
import io.jaegertracing.internal.LogData;
import io.jaegertracing.internal.Reference;
import io.opentracing.Span;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaegerSpan
implements Span {
    private static final Logger log = LoggerFactory.getLogger(JaegerSpan.class);
    private final JaegerTracer tracer;
    private final long startTimeMicroseconds;
    private final long startTimeNanoTicks;
    private final boolean computeDurationViaNanoTicks;
    private final Map<String, Object> tags;
    private long durationMicroseconds;
    private String operationName;
    private final List<Reference> references;
    private JaegerSpanContext context;
    private List<LogData> logs;
    private boolean finished = false;

    protected JaegerSpan(JaegerTracer tracer, String operationName, JaegerSpanContext context, long startTimeMicroseconds, long startTimeNanoTicks, boolean computeDurationViaNanoTicks, Map<String, Object> tags, List<Reference> references) {
        this.tracer = tracer;
        this.operationName = operationName;
        this.context = context;
        this.startTimeMicroseconds = startTimeMicroseconds;
        this.startTimeNanoTicks = startTimeNanoTicks;
        this.computeDurationViaNanoTicks = computeDurationViaNanoTicks;
        this.tags = new HashMap<String, Object>();
        this.references = references != null ? new ArrayList<Reference>(references) : null;
        Object samplingPriorityValue = tags.get(Tags.SAMPLING_PRIORITY.getKey());
        if (samplingPriorityValue != null) {
            this.setTagAsObject(Tags.SAMPLING_PRIORITY.getKey(), samplingPriorityValue);
        }
        for (Map.Entry<String, Object> tag : tags.entrySet()) {
            if (tag.getKey().equals(Tags.SAMPLING_PRIORITY.getKey())) continue;
            this.setTagAsObject(tag.getKey(), tag.getValue());
        }
    }

    public long getStart() {
        return this.startTimeMicroseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        JaegerSpan jaegerSpan = this;
        synchronized (jaegerSpan) {
            return this.finished;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDuration() {
        JaegerSpan jaegerSpan = this;
        synchronized (jaegerSpan) {
            return this.durationMicroseconds;
        }
    }

    public JaegerTracer getTracer() {
        return this.tracer;
    }

    public List<Reference> getReferences() {
        if (this.references == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.references);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getTags() {
        JaegerSpan jaegerSpan = this;
        synchronized (jaegerSpan) {
            return Collections.unmodifiableMap(new HashMap<String, Object>(this.tags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JaegerSpan setOperationName(String operationName) {
        JaegerSpan jaegerSpan = this;
        synchronized (jaegerSpan) {
            this.operationName = operationName;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOperationName() {
        JaegerSpan jaegerSpan = this;
        synchronized (jaegerSpan) {
            return this.operationName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServiceName() {
        JaegerSpan jaegerSpan = this;
        synchronized (jaegerSpan) {
            return this.getTracer().getServiceName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogData> getLogs() {
        JaegerSpan jaegerSpan = this;
        synchronized (jaegerSpan) {
            if (this.logs == null) {
                return null;
            }
            return Collections.unmodifiableList(new ArrayList<LogData>(this.logs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JaegerSpan setBaggageItem(String key, String value2) {
        if (key == null || value2 == null && this.context.getBaggageItem(key) == null) {
            return this;
        }
        JaegerSpan jaegerSpan = this;
        synchronized (jaegerSpan) {
            this.context = this.tracer.setBaggage(this, key, value2);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBaggageItem(String key) {
        JaegerSpan jaegerSpan = this;
        synchronized (jaegerSpan) {
            return this.context.getBaggageItem(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        JaegerSpan jaegerSpan = this;
        synchronized (jaegerSpan) {
            return this.context.toString() + " - " + this.operationName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JaegerSpanContext context() {
        JaegerSpan jaegerSpan = this;
        synchronized (jaegerSpan) {
            return this.context;
        }
    }

    @Override
    public void finish() {
        if (this.computeDurationViaNanoTicks) {
            long nanoDuration = this.tracer.clock().currentNanoTicks() - this.startTimeNanoTicks;
            this.finishWithDuration(nanoDuration / 1000L);
        } else {
            this.finish(this.tracer.clock().currentTimeMicros());
        }
    }

    @Override
    public void finish(long finishMicros) {
        this.finishWithDuration(finishMicros - this.startTimeMicroseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishWithDuration(long durationMicros) {
        JaegerSpan jaegerSpan = this;
        synchronized (jaegerSpan) {
            if (this.finished) {
                log.warn("Span has already been finished; will not be reported again.");
                return;
            }
            this.finished = true;
            this.durationMicroseconds = durationMicros;
        }
        if (this.context.isSampled()) {
            this.tracer.reportSpan(this);
        }
    }

    @Override
    public synchronized JaegerSpan setTag(String key, String value2) {
        return this.setTagAsObject(key, value2);
    }

    @Override
    public synchronized JaegerSpan setTag(String key, boolean value2) {
        return this.setTagAsObject(key, value2);
    }

    @Override
    public synchronized JaegerSpan setTag(String key, Number value2) {
        return this.setTagAsObject(key, value2);
    }

    @Override
    public synchronized <T> Span setTag(Tag<T> tag, T value2) {
        return this.setTagAsObject(tag.getKey(), value2);
    }

    private JaegerSpan setTagAsObject(String key, Object value2) {
        if (key.equals(Tags.SAMPLING_PRIORITY.getKey()) && value2 instanceof Number) {
            int priority = ((Number)value2).intValue();
            byte newFlags = priority > 0 ? (byte)(this.context.getFlags() | 1 | 2) : (byte)(this.context.getFlags() & 0xFFFFFFFE);
            this.context = this.context.withFlags(newFlags);
        }
        if (this.context.isSampled()) {
            this.tags.put(key, value2);
        }
        return this;
    }

    @Override
    public JaegerSpan log(Map<String, ?> fields) {
        return this.log(this.tracer.clock().currentTimeMicros(), null, fields);
    }

    @Override
    public JaegerSpan log(long timestampMicroseconds, Map<String, ?> fields) {
        return this.log(timestampMicroseconds, null, fields);
    }

    @Override
    public JaegerSpan log(String event) {
        return this.log(this.tracer.clock().currentTimeMicros(), event, null);
    }

    @Override
    public JaegerSpan log(long timestampMicroseconds, String event) {
        return this.log(timestampMicroseconds, event, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JaegerSpan log(long timestampMicroseconds, String event, Map<String, ?> fields) {
        JaegerSpan jaegerSpan = this;
        synchronized (jaegerSpan) {
            if (fields == null && event == null) {
                return this;
            }
            if (this.context.isSampled()) {
                if (fields != null && this.tracer.isExpandExceptionLogs()) {
                    fields = JaegerSpan.addExceptionLogs(fields);
                }
                if (this.logs == null) {
                    this.logs = new ArrayList<LogData>();
                }
                this.logs.add(new LogData(timestampMicroseconds, event, fields));
            }
            return this;
        }
    }

    private static Map<String, ?> addExceptionLogs(Map<String, ?> fields) {
        String message;
        Object ex = fields.get("error.object");
        if (!(ex instanceof Throwable)) {
            return fields;
        }
        HashMap errorFields = new HashMap(fields);
        Throwable loggedException = (Throwable)ex;
        if (fields.get("error.kind") == null) {
            errorFields.put("error.kind", loggedException.getClass().getName());
        }
        if (fields.get("message") == null && (message = loggedException.getMessage()) != null) {
            errorFields.put("message", message);
        }
        if (fields.get("stack") == null) {
            StringWriter sw = new StringWriter();
            loggedException.printStackTrace(new PrintWriter(sw));
            errorFields.put("stack", sw.toString());
        }
        return errorFields;
    }
}

