/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.propagation;

import io.jaegertracing.internal.JaegerObjectFactory;
import io.jaegertracing.internal.JaegerSpanContext;
import io.jaegertracing.internal.propagation.HexCodec;
import io.jaegertracing.internal.propagation.PrefixedKeys;
import io.jaegertracing.spi.Codec;
import io.opentracing.propagation.TextMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class B3TextMapCodec
implements Codec<TextMap> {
    protected static final String TRACE_ID_NAME = "X-B3-TraceId";
    protected static final String SPAN_ID_NAME = "X-B3-SpanId";
    protected static final String PARENT_SPAN_ID_NAME = "X-B3-ParentSpanId";
    protected static final String SAMPLED_NAME = "X-B3-Sampled";
    protected static final String FLAGS_NAME = "X-B3-Flags";
    protected static final String BAGGAGE_PREFIX = "baggage-";
    protected static final byte SAMPLED_FLAG = 1;
    protected static final byte DEBUG_FLAG = 2;
    private static final PrefixedKeys keys = new PrefixedKeys();
    private final String baggagePrefix;
    private final JaegerObjectFactory objectFactory;

    @Deprecated
    public B3TextMapCodec() {
        this(new Builder());
    }

    private B3TextMapCodec(Builder builder) {
        this.baggagePrefix = builder.baggagePrefix;
        this.objectFactory = builder.objectFactory;
    }

    @Override
    public void inject(JaegerSpanContext spanContext, TextMap carrier) {
        carrier.put(TRACE_ID_NAME, HexCodec.toLowerHex(spanContext.getTraceIdHigh(), spanContext.getTraceIdLow()));
        if (spanContext.getParentId() != 0L) {
            carrier.put(PARENT_SPAN_ID_NAME, HexCodec.toLowerHex(spanContext.getParentId()));
        }
        carrier.put(SPAN_ID_NAME, HexCodec.toLowerHex(spanContext.getSpanId()));
        carrier.put(SAMPLED_NAME, spanContext.isSampled() ? "1" : "0");
        if (spanContext.isDebug()) {
            carrier.put(FLAGS_NAME, "1");
        }
        for (Map.Entry<String, String> entry : spanContext.baggageItems()) {
            carrier.put(keys.prefixedKey(entry.getKey(), this.baggagePrefix), entry.getValue());
        }
    }

    @Override
    public JaegerSpanContext extract(TextMap carrier) {
        Long traceIdLow = null;
        Long traceIdHigh = 0L;
        Long spanId = null;
        Long parentId = 0L;
        byte flags = 0;
        HashMap<String, String> baggage = null;
        for (Map.Entry<String, String> entry : carrier) {
            if (entry.getKey().equalsIgnoreCase(SAMPLED_NAME)) {
                String value2 = entry.getValue();
                if (!"1".equals(value2) && !"true".equalsIgnoreCase(value2)) continue;
                flags = (byte)(flags | 1);
                continue;
            }
            if (entry.getKey().equalsIgnoreCase(TRACE_ID_NAME)) {
                traceIdLow = HexCodec.lowerHexToUnsignedLong(entry.getValue());
                traceIdHigh = HexCodec.higherHexToUnsignedLong(entry.getValue());
                continue;
            }
            if (entry.getKey().equalsIgnoreCase(PARENT_SPAN_ID_NAME)) {
                parentId = HexCodec.lowerHexToUnsignedLong(entry.getValue());
                continue;
            }
            if (entry.getKey().equalsIgnoreCase(SPAN_ID_NAME)) {
                spanId = HexCodec.lowerHexToUnsignedLong(entry.getValue());
                continue;
            }
            if (entry.getKey().equalsIgnoreCase(FLAGS_NAME)) {
                if (!entry.getValue().equals("1")) continue;
                flags = (byte)(flags | 2);
                continue;
            }
            if (!entry.getKey().startsWith(this.baggagePrefix)) continue;
            if (baggage == null) {
                baggage = new HashMap<String, String>();
            }
            baggage.put(keys.unprefixedKey(entry.getKey(), this.baggagePrefix), entry.getValue());
        }
        if (null != traceIdLow && null != parentId && null != spanId) {
            JaegerSpanContext spanContext = this.objectFactory.createSpanContext(traceIdHigh, traceIdLow, spanId, parentId, flags, Collections.<String, String>emptyMap(), null);
            if (baggage != null) {
                spanContext = spanContext.withBaggage(baggage);
            }
            return spanContext;
        }
        return null;
    }

    public static class Builder {
        private String baggagePrefix = "baggage-";
        private JaegerObjectFactory objectFactory = new JaegerObjectFactory();

        public Builder withBaggagePrefix(String baggagePrefix) {
            this.baggagePrefix = baggagePrefix;
            return this;
        }

        public Builder withObjectFactory(JaegerObjectFactory objectFactory) {
            this.objectFactory = objectFactory;
            return this;
        }

        public B3TextMapCodec build() {
            return new B3TextMapCodec(this);
        }
    }
}

