/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.propagation;

import io.jaegertracing.internal.JaegerObjectFactory;
import io.jaegertracing.internal.JaegerSpanContext;
import io.jaegertracing.spi.Codec;
import io.opentracing.propagation.Binary;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class BinaryCodec
implements Codec<Binary> {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final JaegerObjectFactory objectFactory;

    public BinaryCodec() {
        this(BinaryCodec.builder());
    }

    private BinaryCodec(Builder builder) {
        this.objectFactory = builder.objectFactory;
    }

    private static void writeLong(ByteArrayOutputStream stream2, long value2) {
        stream2.write((byte)(value2 >> 56));
        stream2.write((byte)(value2 >> 48));
        stream2.write((byte)(value2 >> 40));
        stream2.write((byte)(value2 >> 32));
        stream2.write((byte)(value2 >> 24));
        stream2.write((byte)(value2 >> 16));
        stream2.write((byte)(value2 >> 8));
        stream2.write((byte)value2);
    }

    private static void writeInt(ByteArrayOutputStream stream2, int value2) {
        stream2.write((byte)(value2 >> 24));
        stream2.write((byte)(value2 >> 16));
        stream2.write((byte)(value2 >> 8));
        stream2.write((byte)value2);
    }

    private void writeKvPair(ByteArrayOutputStream stream2, String key, String value2) {
        byte[] buf = key.getBytes(DEFAULT_CHARSET);
        int keyLen = buf.length;
        BinaryCodec.writeInt(stream2, keyLen);
        stream2.write(buf, 0, keyLen);
        buf = value2.getBytes(DEFAULT_CHARSET);
        int valLen = value2.length();
        BinaryCodec.writeInt(stream2, valLen);
        stream2.write(buf, 0, valLen);
    }

    private static byte[] checkBuf(int len, byte[] bytes) {
        return len <= bytes.length ? bytes : new byte[len];
    }

    @Override
    public void inject(JaegerSpanContext spanContext, Binary carrier) {
        ByteArrayOutputStream stream2 = new ByteArrayOutputStream(64);
        BinaryCodec.writeLong(stream2, spanContext.getTraceIdHigh());
        BinaryCodec.writeLong(stream2, spanContext.getTraceIdLow());
        BinaryCodec.writeLong(stream2, spanContext.getSpanId());
        BinaryCodec.writeLong(stream2, spanContext.getParentId());
        stream2.write(spanContext.getFlags());
        BinaryCodec.writeInt(stream2, spanContext.baggageCount());
        for (Map.Entry<String, String> entry : spanContext.baggageItems()) {
            this.writeKvPair(stream2, entry.getKey(), entry.getValue());
        }
        int size = stream2.size();
        ByteBuffer buf = carrier.injectionBuffer(size);
        if (buf.order() != ByteOrder.BIG_ENDIAN) {
            throw new IllegalStateException("Carrier byte order must be big endian.");
        }
        buf.put(stream2.toByteArray(), 0, size);
    }

    @Override
    public JaegerSpanContext extract(Binary carrier) {
        HashMap<String, String> baggage = null;
        ByteBuffer buf = carrier.extractionBuffer();
        buf.rewind();
        if (buf.order() != ByteOrder.BIG_ENDIAN) {
            throw new IllegalStateException("Carrier byte order must be big endian.");
        }
        long traceIdHigh = buf.getLong();
        long traceIdLow = buf.getLong();
        long spanId = buf.getLong();
        long parentId = buf.getLong();
        byte flags = buf.get();
        int count = buf.getInt();
        if (count > 0) {
            baggage = new HashMap<String, String>(count);
            byte[] tmp = new byte[32];
            for (int i = 0; i < count; ++i) {
                int len = buf.getInt();
                tmp = BinaryCodec.checkBuf(len, tmp);
                buf.get(tmp, 0, len);
                String key = new String(tmp, 0, len, DEFAULT_CHARSET);
                len = buf.getInt();
                tmp = BinaryCodec.checkBuf(len, tmp);
                buf.get(tmp, 0, len);
                String value2 = new String(tmp, 0, len, DEFAULT_CHARSET);
                baggage.put(key, value2);
            }
        }
        return this.objectFactory.createSpanContext(traceIdHigh, traceIdLow, spanId, parentId, flags, baggage, null);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("BinaryCodec{").append("ObjectFactory=" + this.objectFactory.getClass().getName()).append('}');
        return buffer.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private JaegerObjectFactory objectFactory = new JaegerObjectFactory();

        public Builder withObjectFactory(JaegerObjectFactory objectFactory) {
            this.objectFactory = objectFactory;
            return this;
        }

        public BinaryCodec build() {
            return new BinaryCodec(this);
        }
    }
}

