/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.reporters;

import io.jaegertracing.internal.JaegerSpan;
import io.jaegertracing.spi.Reporter;
import java.util.ArrayList;
import java.util.List;

public class CompositeReporter
implements Reporter {
    private final List<Reporter> reporters = new ArrayList<Reporter>();

    public CompositeReporter(Reporter ... reporters) {
        for (int i = 0; i < reporters.length; ++i) {
            this.reporters.add(reporters[i]);
        }
    }

    @Override
    public void report(JaegerSpan span) {
        for (Reporter reporter2 : this.reporters) {
            reporter2.report(span);
        }
    }

    @Override
    public void close() {
        for (Reporter reporter2 : this.reporters) {
            reporter2.close();
        }
    }

    public String toString() {
        return "CompositeReporter(reporters=" + this.reporters + ")";
    }
}

