/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.marshal;

import io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

public abstract class Serializer
implements AutoCloseable {
    Serializer() {
    }

    public void serializeTraceId(ProtoFieldInfo field, @Nullable String traceId) throws IOException {
        if (traceId == null) {
            return;
        }
        this.writeTraceId(field, traceId);
    }

    protected abstract void writeTraceId(ProtoFieldInfo var1, String var2) throws IOException;

    public void serializeSpanId(ProtoFieldInfo field, @Nullable String spanId) throws IOException {
        if (spanId == null) {
            return;
        }
        this.writeSpanId(field, spanId);
    }

    protected abstract void writeSpanId(ProtoFieldInfo var1, String var2) throws IOException;

    public void serializeBool(ProtoFieldInfo field, boolean value2) throws IOException {
        if (!value2) {
            return;
        }
        this.writeBool(field, value2);
    }

    public abstract void writeBool(ProtoFieldInfo var1, boolean var2) throws IOException;

    public void serializeEnum(ProtoFieldInfo field, ProtoEnumInfo enumValue) throws IOException {
        if (enumValue.getEnumNumber() == 0) {
            return;
        }
        this.writeEnum(field, enumValue);
    }

    protected abstract void writeEnum(ProtoFieldInfo var1, ProtoEnumInfo var2) throws IOException;

    public void serializeUInt32(ProtoFieldInfo field, int value2) throws IOException {
        if (value2 == 0) {
            return;
        }
        this.writeUint32(field, value2);
    }

    protected abstract void writeUint32(ProtoFieldInfo var1, int var2) throws IOException;

    public void serializeSInt32(ProtoFieldInfo field, int value2) throws IOException {
        if (value2 == 0) {
            return;
        }
        this.writeSInt32(field, value2);
    }

    protected abstract void writeSInt32(ProtoFieldInfo var1, int var2) throws IOException;

    public void serializeInt32(ProtoFieldInfo field, int value2) throws IOException {
        if (value2 == 0) {
            return;
        }
        this.writeint32(field, value2);
    }

    protected abstract void writeint32(ProtoFieldInfo var1, int var2) throws IOException;

    public void serializeInt64(ProtoFieldInfo field, long value2) throws IOException {
        if (value2 == 0L) {
            return;
        }
        this.writeInt64(field, value2);
    }

    public abstract void writeInt64(ProtoFieldInfo var1, long var2) throws IOException;

    public void serializeFixed64(ProtoFieldInfo field, long value2) throws IOException {
        if (value2 == 0L) {
            return;
        }
        this.writeFixed64(field, value2);
    }

    public void serializeFixed64Optional(ProtoFieldInfo field, long value2) throws IOException {
        this.writeFixed64(field, value2);
    }

    protected abstract void writeFixed64(ProtoFieldInfo var1, long var2) throws IOException;

    protected abstract void writeFixed64Value(long var1) throws IOException;

    protected abstract void writeUInt64Value(long var1) throws IOException;

    public void serializeFixed32(ProtoFieldInfo field, int value2) throws IOException {
        if (value2 == 0) {
            return;
        }
        this.writeFixed32(field, value2);
    }

    protected abstract void writeFixed32(ProtoFieldInfo var1, int var2) throws IOException;

    public void serializeDouble(ProtoFieldInfo field, double value2) throws IOException {
        if (value2 == 0.0) {
            return;
        }
        this.writeDouble(field, value2);
    }

    public void serializeDoubleOptional(ProtoFieldInfo field, double value2) throws IOException {
        this.writeDouble(field, value2);
    }

    public abstract void writeDouble(ProtoFieldInfo var1, double var2) throws IOException;

    protected abstract void writeDoubleValue(double var1) throws IOException;

    public void serializeString(ProtoFieldInfo field, byte[] utf8Bytes) throws IOException {
        if (utf8Bytes.length == 0) {
            return;
        }
        this.writeString(field, utf8Bytes);
    }

    public abstract void writeString(ProtoFieldInfo var1, byte[] var2) throws IOException;

    public void serializeBytes(ProtoFieldInfo field, byte[] value2) throws IOException {
        if (value2.length == 0) {
            return;
        }
        this.writeBytes(field, value2);
    }

    protected abstract void writeBytes(ProtoFieldInfo var1, byte[] var2) throws IOException;

    protected abstract void writeStartMessage(ProtoFieldInfo var1, int var2) throws IOException;

    protected abstract void writeEndMessage() throws IOException;

    public void serializeMessage(ProtoFieldInfo field, Marshaler message) throws IOException {
        this.writeStartMessage(field, message.getBinarySerializedSize());
        message.writeTo(this);
        this.writeEndMessage();
    }

    protected abstract void writeStartRepeatedPrimitive(ProtoFieldInfo var1, int var2, int var3) throws IOException;

    protected abstract void writeEndRepeatedPrimitive() throws IOException;

    protected abstract void writeStartRepeatedVarint(ProtoFieldInfo var1, int var2) throws IOException;

    protected abstract void writeEndRepeatedVarint() throws IOException;

    public void serializeRepeatedFixed64(ProtoFieldInfo field, List<Long> values2) throws IOException {
        if (values2.isEmpty()) {
            return;
        }
        this.writeStartRepeatedPrimitive(field, 8, values2.size());
        for (long value2 : values2) {
            this.writeFixed64Value(value2);
        }
        this.writeEndRepeatedPrimitive();
    }

    public void serializeRepeatedFixed64(ProtoFieldInfo field, long[] values2) throws IOException {
        if (values2.length == 0) {
            return;
        }
        this.writeStartRepeatedPrimitive(field, 8, values2.length);
        for (long value2 : values2) {
            this.writeFixed64Value(value2);
        }
        this.writeEndRepeatedPrimitive();
    }

    public void serializeRepeatedUInt64(ProtoFieldInfo field, long[] values2) throws IOException {
        if (values2.length == 0) {
            return;
        }
        int payloadSize = 0;
        for (long v : values2) {
            payloadSize += CodedOutputStream.computeUInt64SizeNoTag(v);
        }
        this.writeStartRepeatedVarint(field, payloadSize);
        for (long value2 : values2) {
            this.writeUInt64Value(value2);
        }
        this.writeEndRepeatedVarint();
    }

    public void serializeRepeatedDouble(ProtoFieldInfo field, List<Double> values2) throws IOException {
        if (values2.isEmpty()) {
            return;
        }
        this.writeStartRepeatedPrimitive(field, 8, values2.size());
        for (double value2 : values2) {
            this.writeDoubleValue(value2);
        }
        this.writeEndRepeatedPrimitive();
    }

    public abstract void serializeRepeatedMessage(ProtoFieldInfo var1, Marshaler[] var2) throws IOException;

    public abstract void serializeRepeatedMessage(ProtoFieldInfo var1, List<? extends Marshaler> var2) throws IOException;

    public abstract void writeSerializedMessage(byte[] var1, String var2) throws IOException;

    @Override
    public abstract void close() throws IOException;
}

