/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.zipkin.internal;

import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.time.Duration;

public class ZipkinSpanExporterProvider
implements ConfigurableSpanExporterProvider {
    public String getName() {
        return "zipkin";
    }

    public SpanExporter createExporter(ConfigProperties config2) {
        Duration timeout2;
        ZipkinSpanExporterBuilder builder = ZipkinSpanExporter.builder();
        String endpoint = config2.getString("otel.exporter.zipkin.endpoint");
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if ((timeout2 = config2.getDuration("otel.exporter.zipkin.timeout")) != null) {
            builder.setReadTimeout(timeout2);
        }
        return builder.build();
    }
}

