/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.blob.IOUtil;
import org.apache.axiom.blob.OverflowableBlob;
import org.apache.axiom.blob.State;
import org.apache.axiom.blob.WritableBlob;
import org.apache.axiom.blob.WritableBlobFactory;
import org.apache.axiom.ext.io.ReadFromSupport;
import org.apache.axiom.ext.io.StreamCopyException;

final class OverflowableBlobImpl
implements OverflowableBlob {
    final int chunkSize;
    final WritableBlobFactory overflowBlobFactory;
    byte[][] chunks;
    int chunkIndex;
    int chunkOffset;
    WritableBlob overflowBlob;
    State state = State.NEW;

    OverflowableBlobImpl(int numberOfChunks, int chunkSize, WritableBlobFactory overflowBlobFactory) {
        this.chunkSize = chunkSize;
        this.overflowBlobFactory = overflowBlobFactory;
        this.chunks = new byte[numberOfChunks][];
    }

    byte[] getCurrentChunk() {
        if (this.chunkOffset == 0) {
            byte[] chunk = new byte[this.chunkSize];
            this.chunks[this.chunkIndex] = chunk;
            return chunk;
        }
        return this.chunks[this.chunkIndex];
    }

    OutputStream switchToOverflowBlob() throws IOException {
        this.overflowBlob = this.overflowBlobFactory.createBlob();
        OutputStream outputStream2 = this.overflowBlob.getOutputStream();
        for (int i = 0; i < this.chunkIndex; ++i) {
            outputStream2.write(this.chunks[i]);
        }
        if (this.chunkOffset > 0) {
            outputStream2.write(this.chunks[this.chunkIndex], 0, this.chunkOffset);
        }
        this.chunks = null;
        return outputStream2;
    }

    public OutputStream getOutputStream() {
        if (this.state != State.NEW) {
            throw new IllegalStateException();
        }
        this.state = State.UNCOMMITTED;
        return new OutputStreamImpl();
    }

    long readFrom(InputStream in, long length, boolean commit) throws StreamCopyException {
        long toRead;
        if (this.state == State.COMMITTED) {
            throw new IllegalStateException();
        }
        long read = 0L;
        long l = toRead = length == -1L ? Long.MAX_VALUE : length;
        while (toRead > 0L) {
            OutputStream out;
            int c;
            try {
                int len = this.chunkSize - this.chunkOffset;
                if ((long)len > toRead) {
                    len = (int)toRead;
                }
                c = in.read(this.getCurrentChunk(), this.chunkOffset, len);
            }
            catch (IOException ex) {
                throw new StreamCopyException(1, ex);
            }
            if (c == -1) break;
            read += (long)c;
            toRead -= (long)c;
            this.chunkOffset += c;
            if (this.chunkOffset != this.chunkSize) continue;
            ++this.chunkIndex;
            this.chunkOffset = 0;
            if (this.chunkIndex != this.chunks.length) continue;
            try {
                out = this.switchToOverflowBlob();
            }
            catch (IOException ex) {
                throw new StreamCopyException(2, ex);
            }
            read += IOUtil.copy(in, out, toRead);
            try {
                out.close();
                break;
            }
            catch (IOException ex) {
                throw new StreamCopyException(2, ex);
            }
        }
        this.state = commit ? State.COMMITTED : State.UNCOMMITTED;
        return read;
    }

    public long readFrom(InputStream in) throws StreamCopyException {
        if (this.state != State.NEW) {
            throw new IllegalStateException();
        }
        return this.readFrom(in, -1L, true);
    }

    public InputStream getInputStream() throws IOException {
        if (this.state != State.COMMITTED) {
            throw new IllegalStateException();
        }
        if (this.overflowBlob != null) {
            return this.overflowBlob.getInputStream();
        }
        return new InputStreamImpl();
    }

    public void writeTo(OutputStream out) throws StreamCopyException {
        if (this.state != State.COMMITTED) {
            throw new IllegalStateException();
        }
        if (this.overflowBlob != null) {
            this.overflowBlob.writeTo(out);
        } else {
            try {
                for (int i = 0; i < this.chunkIndex; ++i) {
                    out.write(this.chunks[i]);
                }
                if (this.chunkOffset > 0) {
                    out.write(this.chunks[this.chunkIndex], 0, this.chunkOffset);
                }
            }
            catch (IOException ex) {
                throw new StreamCopyException(2, ex);
            }
        }
    }

    public long getSize() {
        if (this.state != State.COMMITTED) {
            throw new IllegalStateException();
        }
        if (this.overflowBlob != null) {
            return this.overflowBlob.getSize();
        }
        return this.chunkIndex * this.chunkSize + this.chunkOffset;
    }

    public void release() throws IOException {
        if (this.overflowBlob != null) {
            this.overflowBlob.release();
            this.overflowBlob = null;
        }
        this.state = State.RELEASED;
    }

    public WritableBlob getOverflowBlob() {
        return this.overflowBlob;
    }

    class InputStreamImpl
    extends InputStream {
        private int currentChunkIndex;
        private int currentChunkOffset;
        private int markChunkIndex;
        private int markChunkOffset;

        InputStreamImpl() {
        }

        public int available() throws IOException {
            return (OverflowableBlobImpl.this.chunkIndex - this.currentChunkIndex) * OverflowableBlobImpl.this.chunkSize + OverflowableBlobImpl.this.chunkOffset - this.currentChunkOffset;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            int read = 0;
            while (len > 0 && (this.currentChunkIndex != OverflowableBlobImpl.this.chunkIndex || this.currentChunkOffset != OverflowableBlobImpl.this.chunkOffset)) {
                int c = this.currentChunkIndex == OverflowableBlobImpl.this.chunkIndex ? Math.min(len, OverflowableBlobImpl.this.chunkOffset - this.currentChunkOffset) : Math.min(len, OverflowableBlobImpl.this.chunkSize - this.currentChunkOffset);
                System.arraycopy(OverflowableBlobImpl.this.chunks[this.currentChunkIndex], this.currentChunkOffset, b, off, c);
                len -= c;
                off += c;
                this.currentChunkOffset += c;
                read += c;
                if (this.currentChunkOffset != OverflowableBlobImpl.this.chunkSize) continue;
                ++this.currentChunkIndex;
                this.currentChunkOffset = 0;
            }
            if (read == 0) {
                return -1;
            }
            return read;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            return this.read(b) == -1 ? -1 : b[0] & 0xFF;
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int readlimit) {
            this.markChunkIndex = this.currentChunkIndex;
            this.markChunkOffset = this.currentChunkOffset;
        }

        public void reset() throws IOException {
            this.currentChunkIndex = this.markChunkIndex;
            this.currentChunkOffset = this.markChunkOffset;
        }

        public long skip(long n) throws IOException {
            int available = this.available();
            int c = n < (long)available ? (int)n : available;
            int newOffset = this.currentChunkOffset + c;
            int chunkDelta = newOffset / OverflowableBlobImpl.this.chunkSize;
            this.currentChunkIndex += chunkDelta;
            this.currentChunkOffset = newOffset - chunkDelta * OverflowableBlobImpl.this.chunkSize;
            return c;
        }

        public void close() throws IOException {
        }
    }

    class OutputStreamImpl
    extends OutputStream
    implements ReadFromSupport {
        private OutputStream overflowOutputStream;

        OutputStreamImpl() {
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (OverflowableBlobImpl.this.state != State.UNCOMMITTED) {
                throw new IllegalStateException();
            }
            if (this.overflowOutputStream != null) {
                this.overflowOutputStream.write(b, off, len);
            } else if (len > (OverflowableBlobImpl.this.chunks.length - OverflowableBlobImpl.this.chunkIndex) * OverflowableBlobImpl.this.chunkSize - OverflowableBlobImpl.this.chunkOffset) {
                this.overflowOutputStream = OverflowableBlobImpl.this.switchToOverflowBlob();
                this.overflowOutputStream.write(b, off, len);
            } else {
                while (len > 0) {
                    byte[] chunk = OverflowableBlobImpl.this.getCurrentChunk();
                    int c = Math.min(len, OverflowableBlobImpl.this.chunkSize - OverflowableBlobImpl.this.chunkOffset);
                    System.arraycopy(b, off, chunk, OverflowableBlobImpl.this.chunkOffset, c);
                    len -= c;
                    off += c;
                    OverflowableBlobImpl.this.chunkOffset += c;
                    if (OverflowableBlobImpl.this.chunkOffset != OverflowableBlobImpl.this.chunkSize) continue;
                    ++OverflowableBlobImpl.this.chunkIndex;
                    OverflowableBlobImpl.this.chunkOffset = 0;
                }
            }
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        public void close() throws IOException {
            if (this.overflowOutputStream != null) {
                this.overflowOutputStream.close();
            }
            OverflowableBlobImpl.this.state = State.COMMITTED;
        }

        public long readFrom(InputStream in, long length) throws StreamCopyException {
            return OverflowableBlobImpl.this.readFrom(in, length, false);
        }
    }
}

